/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc;

import com.sap.cds.impl.jdbc.DbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DbTypeAnalyzer {
    private DbTypeAnalyzer() {
    }

    public static DbType analyze(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        String productName = metaData.getDatabaseProductName();
        if (productName.contains("SQLite")) {
            return DbType.SQLITE;
        }
        if (productName.contains("HDB")) {
            return DbType.HANA;
        }
        if (productName.contains("H2")) {
            return DbType.H2;
        }
        if (productName.contains("PostgreSQL")) {
            return DbType.POSTGRES;
        }
        return DbType.OTHER;
    }
}

