/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc;

import com.sap.cds.impl.jdbc.JDBCBinder;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Calendar;

public class GenericBinder
extends JDBCBinder {
    private static GenericBinder instance;

    public GenericBinder(int timestampFractionalSeconds) {
        super(timestampFractionalSeconds);
    }

    @Override
    protected Instant getInstant(ResultSet result, int i) throws SQLException {
        Timestamp dt = result.getTimestamp(i, (Calendar)UTC.get());
        return dt != null ? dt.toInstant() : null;
    }

    @Override
    protected void setInstant(PreparedStatement pstmt, int i, Instant instant) throws SQLException {
        Timestamp ts = Timestamp.from(instant);
        pstmt.setTimestamp(i, ts, (Calendar)UTC.get());
    }

    @Override
    protected LocalDate getLocalDate(ResultSet result, int i) throws SQLException {
        Date date = result.getDate(i, GenericBinder.getCalendarForDefaultTimeZone());
        return date != null ? date.toLocalDate() : null;
    }

    @Override
    protected void setLocalDate(PreparedStatement pstmt, int i, LocalDate localDate) throws SQLException {
        Date date = Date.valueOf(localDate);
        pstmt.setDate(i, date, GenericBinder.getCalendarForDefaultTimeZone());
    }

    @Override
    protected Object getLocalTime(ResultSet result, int i) throws SQLException {
        Time time = result.getTime(i, GenericBinder.getCalendarForDefaultTimeZone());
        return time != null ? time.toLocalTime() : null;
    }

    @Override
    protected void setLocalTime(PreparedStatement pstmt, int i, LocalTime localTime) throws SQLException {
        Time time = Time.valueOf(localTime);
        pstmt.setTime(i, time, GenericBinder.getCalendarForDefaultTimeZone());
    }

    @Override
    protected Reader getLargeString(ResultSet result, int i) throws SQLException {
        return result.getCharacterStream(i);
    }

    @Override
    protected void setLargeString(PreparedStatement pstmt, int i, Reader reader) throws SQLException {
        pstmt.setCharacterStream(i, reader);
    }

    @Override
    protected InputStream getLargeBinary(ResultSet result, int i) throws SQLException {
        return result.getBinaryStream(i);
    }

    @Override
    protected void setLargeBinary(PreparedStatement pstmt, int i, InputStream stream) throws SQLException {
        pstmt.setBinaryStream(i, stream);
    }
}

