/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.TableNameResolver;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Arrays;
import java.util.Locale;

public class GenericTableNameResolver
implements TableNameResolver {
    private static final String DEFAULT_SUPPORTED_LOCALES = "de,fr";
    private final DataStoreConfiguration dataStoreConfiguration;

    public GenericTableNameResolver(DataStoreConfiguration dataStoreConfiguration) {
        this.dataStoreConfiguration = dataStoreConfiguration;
    }

    @Override
    public String tableName(Context context, CdsEntity entity) {
        Locale locale;
        if (LocaleUtils.isLocalized((CdsEntity)entity) && this.validLocale(locale = context.getSessionContext().getLocale())) {
            String localeSpecifcViewName = LocaleUtils.localizedEntityName((String)entity.getQualifiedName(), (Locale)locale);
            return SqlMapping.plainTableName(localeSpecifcViewName);
        }
        return new SqlMapping((CdsStructuredType)entity).tableName();
    }

    private boolean validLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        String supportedLocales = this.dataStoreConfiguration.getProperty("supported_locales", DEFAULT_SUPPORTED_LOCALES);
        return Arrays.asList(supportedLocales.split(",")).contains(locale.getLanguage());
    }
}

