/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc;

import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CdsTypeUtils;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class JDBCBinder {
    private static final ThreadLocal<Calendar> LOCAL_CALENDAR = new ThreadLocal();
    protected static final ThreadLocal<Calendar> UTC = ThreadLocal.withInitial(() -> Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    private final int timestampFractionalSeconds;

    protected JDBCBinder(int timestampFractionalSeconds) {
        this.timestampFractionalSeconds = timestampFractionalSeconds;
    }

    public void setValue(PreparedStatement pstmt, int i, Object value, CdsBaseType cdsType) throws SQLException {
        if (cdsType != null && value instanceof String) {
            String val = (String)value;
            switch (cdsType) {
                case TIMESTAMP: {
                    this.setInstant(pstmt, i, CdsTypeUtils.timestamp((Object)val, (int)this.timestampFractionalSeconds));
                    break;
                }
                case DATETIME: {
                    this.setInstant(pstmt, i, CdsTypeUtils.dateTime((Object)val));
                    break;
                }
                case DATE: {
                    this.setLocalDate(pstmt, i, LocalDate.parse(val));
                    break;
                }
                case TIME: {
                    this.setLocalTime(pstmt, i, LocalTime.parse(val));
                    break;
                }
                case UUID: {
                    pstmt.setString(i, CdsTypeUtils.parseUuid((Object)val));
                    break;
                }
                default: {
                    pstmt.setObject(i, val);
                    break;
                }
            }
        } else if (value instanceof Instant) {
            this.setInstant(pstmt, i, (Instant)value);
        } else if (value instanceof LocalDate) {
            this.setLocalDate(pstmt, i, (LocalDate)value);
        } else if (value instanceof LocalTime) {
            this.setLocalTime(pstmt, i, (LocalTime)value);
        } else if (value instanceof ZonedDateTime) {
            this.setZonedDateTime(pstmt, i, (ZonedDateTime)value);
        } else if (value instanceof Timestamp) {
            this.setInstant(pstmt, i, ((Timestamp)value).toInstant());
        } else if (value instanceof Time) {
            this.setLocalTime(pstmt, i, ((Time)value).toLocalTime());
        } else if (value instanceof Date) {
            this.setLocalDate(pstmt, i, ((Date)value).toLocalDate());
        } else if (value instanceof Reader) {
            this.setLargeString(pstmt, i, (Reader)value);
        } else if (value instanceof InputStream) {
            this.setLargeBinary(pstmt, i, (InputStream)value);
        } else {
            pstmt.setObject(i, value);
        }
    }

    private void setZonedDateTime(PreparedStatement pstmt, int i, ZonedDateTime zonedDateTime) throws SQLException {
        this.setInstant(pstmt, i, CdsTypeUtils.dateTime((Instant)zonedDateTime.toInstant()));
    }

    protected abstract void setLocalTime(PreparedStatement var1, int var2, LocalTime var3) throws SQLException;

    protected abstract void setLocalDate(PreparedStatement var1, int var2, LocalDate var3) throws SQLException;

    protected abstract void setInstant(PreparedStatement var1, int var2, Instant var3) throws SQLException;

    protected abstract void setLargeString(PreparedStatement var1, int var2, Reader var3) throws SQLException;

    protected abstract void setLargeBinary(PreparedStatement var1, int var2, InputStream var3) throws SQLException;

    public <T> T getValue(ResultSet result, CdsBaseType cdsType, boolean isMediaType, int i) throws SQLException {
        if (cdsType != null) {
            return (T)this.getValueFromResult(result, cdsType, isMediaType, i);
        }
        return (T)result.getObject(i);
    }

    private Object getValueFromResult(ResultSet result, CdsBaseType cdsType, boolean isMediaType, int i) throws SQLException {
        switch (cdsType) {
            case BOOLEAN: {
                boolean bool = result.getBoolean(i);
                return result.wasNull() ? null : Boolean.valueOf(bool);
            }
            case DATE: {
                return this.getLocalDate(result, i);
            }
            case DATETIME: {
                return CdsTypeUtils.dateTime((Instant)this.getInstant(result, i));
            }
            case DECIMAL: 
            case HANA_SMALLDECIMAL: 
            case DECIMAL_FLOAT: {
                return result.getBigDecimal(i);
            }
            case DOUBLE: {
                double dbl = result.getDouble(i);
                return result.wasNull() ? null : Double.valueOf(dbl);
            }
            case INTEGER: {
                int in = result.getInt(i);
                return result.wasNull() ? null : Integer.valueOf(in);
            }
            case INTEGER64: {
                long int64 = result.getLong(i);
                return result.wasNull() ? null : Long.valueOf(int64);
            }
            case LARGE_BINARY: {
                if (isMediaType) {
                    return this.getLargeBinary(result, i);
                }
            }
            case HANA_BINARY: 
            case BINARY: {
                return result.getBytes(i);
            }
            case HANA_CLOB: 
            case LARGE_STRING: {
                if (isMediaType) {
                    return this.getLargeString(result, i);
                }
            }
            case STRING: {
                String str = result.getString(i);
                return result.wasNull() ? null : str;
            }
            case TIME: {
                return this.getLocalTime(result, i);
            }
            case TIMESTAMP: {
                return CdsTypeUtils.timestamp((Instant)this.getInstant(result, i), (int)this.timestampFractionalSeconds);
            }
            case HANA_TINYINT: 
            case HANA_SMALLINT: {
                short smallInt = result.getShort(i);
                return result.wasNull() ? null : Short.valueOf(smallInt);
            }
            case HANA_REAL: {
                float real = result.getFloat(i);
                return result.wasNull() ? null : Float.valueOf(real);
            }
        }
        return result.getObject(i);
    }

    protected abstract Object getLocalTime(ResultSet var1, int var2) throws SQLException;

    protected abstract Object getLocalDate(ResultSet var1, int var2) throws SQLException;

    protected abstract Instant getInstant(ResultSet var1, int var2) throws SQLException;

    protected abstract Reader getLargeString(ResultSet var1, int var2) throws SQLException;

    protected abstract InputStream getLargeBinary(ResultSet var1, int var2) throws SQLException;

    protected static Calendar getCalendarForDefaultTimeZone() {
        Calendar calendar = LOCAL_CALENDAR.get();
        if (null == calendar || !calendar.getTimeZone().getDisplayName().equals(TimeZone.getDefault().getDisplayName())) {
            LOCAL_CALENDAR.set(Calendar.getInstance(TimeZone.getDefault()));
        }
        return LOCAL_CALENDAR.get();
    }
}

