/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc.hana;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.AbstractSearchResolver;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.draft.DraftUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaSearchResolver
extends AbstractSearchResolver
implements SearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolver.class);
    private final CdsModel model;
    private Supplier<SessionContext> sessionContextSupplier;
    private boolean inSubquery = false;

    public HanaSearchResolver(CdsModel model) {
        this.model = model;
    }

    public HanaSearchResolver(CdsModel model, Supplier<SessionContext> sessionContextSupplier) {
        this(model);
        this.sessionContextSupplier = sessionContextSupplier;
    }

    private boolean isActiveEntity(CdsStructuredType targetType) {
        return DraftUtils.isDraftEnabled(targetType) && !DraftUtils.isDraftView(targetType);
    }

    private boolean anyRefIsDeclaredByActiveEntity(CdsStructuredType root, Collection<ElementRef<?>> refs) {
        for (ElementRef<?> ref : refs) {
            CdsStructuredType declaringType = (CdsStructuredType)CdsModelUtils.element((CdsStructuredType)root, ref).getDeclaringType();
            if (!this.isActiveEntity(declaringType)) continue;
            return true;
        }
        return false;
    }

    public CqnSelect resolve(CqnSelect select) {
        select.search().ifPresent(search -> {
            Collection<ElementRef<?>> searchableRefs;
            CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
            AbstractSearchResolver.SearchMode searchMode = this.determineSearchMode(select, targetType, searchableRefs = this.getSearchableElementRefsConsideringIncludeList(select, targetType));
            if (searchMode.isUseContains()) {
                this.resolveUsingLocalizedAssociationWithContains(select, (CqnPredicate)search, targetType, searchableRefs, searchMode);
            } else {
                this.resolveUsingLocalizedViewWithLike(select, (CqnPredicate)search, targetType, searchableRefs, searchMode.isUseExistsSubquery());
            }
        });
        return select;
    }

    private void resolveUsingLocalizedAssociationWithContains(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs, AbstractSearchResolver.SearchMode searchMode) {
        if (searchMode.isResolveLocalizedElements()) {
            searchableRefs = this.addRefsViaLocalizedAssociation(targetType, searchableRefs);
        }
        CqnPredicate filter = this.searchToHanaContains(searchableRefs, search);
        if (searchMode.isUseExistsSubquery()) {
            filter = HanaSearchResolver.pushDownToExistsSubquery((CdsStructuredType)targetType, (CqnPredicate)filter, (boolean)true);
        }
        HanaSearchResolver.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    private AbstractSearchResolver.SearchMode determineSearchMode(CqnSelect select, CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs) {
        boolean useContains;
        boolean languageGiven = this.sessionContextSupplier != null && this.sessionContextSupplier.get().getLocale() != null;
        boolean hasLocalizedElements = LocaleUtils.hasLocalizedElements((CdsStructuredType)targetType, searchableRefs);
        boolean unsupportedViewQuery = this.searchesViewWithUnsupportedQuery(select, searchableRefs);
        boolean isActiveEntityOfDraft = this.anyRefIsDeclaredByActiveEntity(targetType, searchableRefs);
        boolean hasAliasedLocalizedElementsBehindAssociation = this.hasAliasedLocalizedElementsInView(targetType, searchableRefs);
        boolean useLocalizedAssociationForTextResolution = languageGiven && hasLocalizedElements && this.allLocalizedElementsHaveAssociationToTexts(targetType, searchableRefs) && !hasAliasedLocalizedElementsBehindAssociation;
        boolean useExistsSubQuery = useLocalizedAssociationForTextResolution || HanaSearchResolver.anyRefViaCollectionAssociation((CdsStructuredType)targetType, searchableRefs) || isActiveEntityOfDraft;
        boolean bl = useContains = (!languageGiven || !hasLocalizedElements || useLocalizedAssociationForTextResolution) && !unsupportedViewQuery;
        if (!useContains) {
            logger.info("Search with LIKE over {}'{}' may have a negative performance impact. Activate debug log for more details.", (Object)(useLocalizedAssociationForTextResolution ? "the localized view of " : ""), (Object)targetType);
            logger.debug("Fallback to search with LIKE over {}'{}'. The following conditions lead to the operation: language: {}, hasLocalizedElements: {}, useLocalizedAssociationForTextResolution: {}, searchesCalculatedFields: {}", new Object[]{useLocalizedAssociationForTextResolution ? "the localized view of " : "", targetType, languageGiven, hasLocalizedElements, useLocalizedAssociationForTextResolution, unsupportedViewQuery});
        }
        return AbstractSearchResolver.SearchMode.of((boolean)useContains, (boolean)useExistsSubQuery, (boolean)languageGiven);
    }

    public void pushDownSearchToSubquery(CqnSelect select, CqnSelect subquery) {
        this.inSubquery = true;
        CqnPredicate merged = (CqnPredicate)Conjunction.and((Optional)subquery.asSelect().search(), (Optional)select.search()).orElse(CqnBoolLiteral.TRUE);
        ((SelectBuilder)subquery.asSelect()).search(merged);
        ((SelectBuilder)select).search((CqnPredicate)null);
    }

    private boolean searchesViewWithUnsupportedQuery(CqnSelect select, Collection<? extends CqnElementRef> searchableRefs) {
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.ref());
        if (!entity.query().isPresent()) {
            return false;
        }
        Set searchableRefNames = searchableRefs.stream().map(CqnSelectListValue::displayName).collect(Collectors.toSet());
        CqnSelect entityQuery = (CqnSelect)entity.query().orElseThrow(() -> new IllegalStateException("query cannot be empty. it was checked before."));
        Collection localSearchableValues = entityQuery.items().stream().filter(CqnSelectListItem::isValue).map(CqnSelectListItem::asValue).filter(slv -> searchableRefNames.contains(slv.displayName())).collect(Collectors.toList());
        boolean searchesCalculatedField = localSearchableValues.stream().anyMatch(slv -> !slv.value().isRef());
        if (searchesCalculatedField) {
            return true;
        }
        if (!localSearchableValues.isEmpty()) {
            searchableRefs = localSearchableValues.stream().map(slv -> slv.value().asRef()).collect(Collectors.toList());
        }
        if (!entityQuery.from().isRef()) {
            return true;
        }
        return this.searchesViewWithUnsupportedQuery(entityQuery, searchableRefs);
    }

    private Collection<ElementRef<?>> getSearchableElementRefsConsideringIncludeList(CqnSelect select, CdsStructuredType targetType) {
        Collection searchableRefs;
        if (this.inSubquery) {
            Set including = select.items().stream().filter(CqnSelectListItem::isValue).map(item -> item.asValue().value()).filter(CqnValue::isRef).map(val -> val.asRef().lastSegment()).collect(Collectors.toSet());
            searchableRefs = HanaSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType).stream().filter(elementRef -> including.contains(elementRef.lastSegment())).collect(Collectors.toList());
        } else {
            searchableRefs = HanaSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
        }
        return searchableRefs;
    }

    private CqnPredicate searchToHanaContains(Collection<ElementRef<?>> searchableRefs, CqnPredicate expression) {
        if (searchableRefs.isEmpty()) {
            return CqnBoolLiteral.FALSE;
        }
        ListValue refs = ListValue.of(searchableRefs);
        CqnValue searchExpression = this.cqnSearchPredicateToHanaContainsSearchString((CqnPredicate)CqnStatementUtils.simplifyPredicate((CqnPredicate)expression));
        return CQL.booleanFunc((String)"CONTAINS", Arrays.asList(refs, searchExpression));
    }

    private CqnValue cqnSearchPredicateToHanaContainsSearchString(CqnPredicate expression) {
        final Stack stack = new Stack();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchPredicate search) {
                String searchTerm = search.searchTerm();
                if (searchTerm.trim().contains(" ")) {
                    stack.push((Object)("*\"" + searchTerm + "\"*"));
                } else {
                    stack.push((Object)("*" + searchTerm + "*"));
                }
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                String delimiter = connective.operator() == CqnConnectivePredicate.Operator.AND ? " " : " OR ";
                stack.push((Object)String.join((CharSequence)delimiter, stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push((Object)("-" + (String)stack.pop()));
            }
        };
        expression.accept(visitor);
        if (stack.isEmpty()) {
            throw new IllegalStateException("the search term stack must not be empty!");
        }
        return CQL.val((Object)stack.pop());
    }
}

