/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc.hana;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.qat.StatementResolver;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnStatement;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

public class HanaStatementResolver
implements StatementResolver {
    private final DataStoreConfiguration dataStoreConfiguration;

    public HanaStatementResolver(DataStoreConfiguration dataStoreConfiguration) {
        this.dataStoreConfiguration = dataStoreConfiguration;
    }

    @Override
    public Stream<String> timeout(Optional<CqnLock> lock) {
        Stream.Builder stream = Stream.builder();
        lock.flatMap(CqnLock::timeout).ifPresent(t -> stream.add("WAIT").add(t.toString()));
        return stream.build();
    }

    @Override
    public Optional<String> collateClause(CqnStatement statement, Locale locale) {
        boolean ignoreLocaleOnHana = this.dataStoreConfiguration.getProperty("cds.sql.hana.ignore-locale", false);
        if (locale != null && !ignoreLocaleOnHana && this.statementNeedsCollateClause(statement)) {
            return Optional.of("with parameters('LOCALE' = " + SQLHelper.literal(locale.getLanguage()) + ")");
        }
        return Optional.empty();
    }

    private boolean statementNeedsCollateClause(CqnStatement statement) {
        return statement.isDelete() && statement.asDelete().where().isPresent() || statement.isUpdate() && statement.asUpdate().where().isPresent() || statement.isSelect();
    }
}

