/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc.hana.docstore;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.jdbc.hana.docstore.DocStoreUtils;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class DocStoreDeleteStatementBuilder {
    private final CqnDelete delete;
    private final TokenToSQLTransformer toSql;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final CdsEntity entity;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DocStoreDeleteStatementBuilder(Context context, CqnDelete delete) {
        this.delete = delete;
        this.entity = context.getCdsModel().getEntity(this.delete.ref().firstSegment());
        this.sqlMapping = new SqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSql = new TokenToSQLTransformer(context, this.sqlMapping::jsonObjectPath, this.entity, this.tableName, this.params, DocStoreUtils::valueToParamCastExpression);
    }

    public SQLStatementBuilder.SQLStatement build() {
        Stream.Builder<String> builder = Stream.builder();
        builder.add("DELETE FROM");
        builder.add(this.tableName);
        this.delete.where().map(this.toSql::toSQL).ifPresent(whereSql -> {
            builder.add("WHERE");
            builder.add((String)whereSql);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }
}

