/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class ContainsToLike {
    private static final String TOLOWER = "tolower";
    private static final char ESCAPE_CHAR = '\\';
    private static final CqnValue ESCAPE_LITERAL = CQL.constant((Object)"\\");
    private static final CqnPlain LIKE = CqnPlainImpl.plain((String)"LIKE");
    private static final CqnPlain ESCAPE = CqnPlainImpl.plain((String)"ESCAPE");

    public static CqnPredicate transform(CqnPredicate pred) {
        return CQL.copy((CqnPredicate)pred, (Modifier)new Modifier(){

            public Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue term, boolean caseInsensitive) {
                if (caseInsensitive) {
                    value = CQL.func((String)ContainsToLike.TOLOWER, (CqnValue[])new CqnValue[]{value});
                    term = CQL.func((String)ContainsToLike.TOLOWER, (CqnValue[])new CqnValue[]{term});
                }
                CqnValue pattern = ContainsToLike.escapeTerm(position, term);
                return ExpressionBuilder.create((CqnToken[])new CqnToken[]{value, LIKE, pattern, ESCAPE, ESCAPE_LITERAL}).predicate();
            }
        });
    }

    private static CqnValue escapeTerm(final CqnContainmentTest.Position position, CqnValue term) {
        return ExpressionVisitor.copy((CqnValue)term, (Modifier)new Modifier(){

            public CqnValue literal(CqnLiteral<?> literal) {
                if (literal.isString()) {
                    String term = SQLHelper.escapeLikePattern('\\', (String)literal.asString().value());
                    switch (position) {
                        case START: {
                            term = term + '%';
                            break;
                        }
                        case ANY: {
                            term = '%' + term + '%';
                            break;
                        }
                        case END: {
                            term = '%' + term;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unexpected position: " + position);
                        }
                    }
                    return CQL.val((Object)term);
                }
                return literal;
            }
        });
    }
}

