/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InsertStatementBuilder
implements SQLStatementBuilder {
    private final CqnInsert insert;
    private final SqlMapping sqlMapping;
    private final CdsEntity entity;

    public InsertStatementBuilder(Context context, CqnInsert insert) {
        this.insert = insert;
        CqnStructuredTypeRef ref = insert.ref();
        this.entity = context.getCdsModel().getEntity(ref.firstSegment());
        this.sqlMapping = new SqlMapping((CdsStructuredType)this.entity);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        ArrayList<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();
        String tableName = this.sqlMapping.tableName();
        String columnsString = InsertStatementBuilder.commaSeparated(this.insert.elements().map(e -> {
            ElementRef ref = ElementRefImpl.parse((String)e);
            params.add(this.param((String)e, (CqnElementRef)ref));
            return this.sqlMapping.columnName((CqnElementRef)ref);
        }));
        String ps = InsertStatementBuilder.commaSeparated(this.insert.elements().map(c -> "?"));
        String sql = Stream.of("INSERT", "INTO", tableName, columnsString, "VALUES", ps).collect(Collectors.joining(" "));
        return new SQLStatementBuilder.SQLStatement(sql, params);
    }

    private PreparedCqnStmt.DataParam param(String path, CqnElementRef ref) {
        CdsElement element = CdsModelUtils.element((CdsStructuredType)this.entity, (CqnElementRef)ref);
        CdsType type = element.getType();
        CdsBaseType baseType = type.isSimple() ? ((CdsSimpleType)type.as(CdsSimpleType.class)).getType() : null;
        return new PreparedCqnStmt.DataParam(path, baseType);
    }

    private static String commaSeparated(Stream<String> stream) {
        return stream.collect(Collectors.joining(", ", "(", ")"));
    }
}

