/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

public class SQLHelper {
    private static final char DQ = '\"';
    private static final char SQ = '\'';

    private SQLHelper() {
    }

    public static String delimited(String undelimited) {
        return '\"' + SQLHelper.prefix(undelimited, '\"', '\"') + '\"';
    }

    public static String literal(String text) {
        return text == null ? "NULL" : '\'' + SQLHelper.prefix(text, '\'', '\'') + '\'';
    }

    public static String escapeLikePattern(char escapeChar, String text) {
        text = SQLHelper.prefix(text, escapeChar, '_');
        text = SQLHelper.prefix(text, escapeChar, '%');
        return text;
    }

    private static String prefix(String text, char escapeChar, char toBeEscaped) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != toBeEscaped) continue;
            return SQLHelper.prefixFrom(text, i, escapeChar, text.length(), toBeEscaped);
        }
        return text;
    }

    private static String prefixFrom(String text, int from, char escapeChar, int length, char toBeEscaped) {
        char[] buffer = new char[length * 2];
        text.getChars(0, from, buffer, 0);
        int j = from;
        for (int i = from; i < length; ++i) {
            char c = text.charAt(i);
            if (c == toBeEscaped) {
                buffer[j++] = escapeChar;
            }
            buffer[j++] = c;
        }
        return String.copyValueOf(buffer, 0, j);
    }
}

