/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class SqlMapping {
    private static final String CDS_PERSISTENCE_NAME = "cds.persistence.name";
    private final CdsStructuredType rowType;

    public SqlMapping(CdsStructuredType rowType) {
        this.rowType = rowType;
    }

    public String tableName() {
        CdsEntity entity = this.asEntity();
        return this.annotatedName().map(SQLHelper::delimited).orElseGet(() -> SqlMapping.plainTableName(entity.getQualifiedName()));
    }

    public String localizedViewName() {
        CdsEntity entity = this.asEntity();
        return this.annotatedName().filter(n -> !this.uppercaseOnly((String)n)).map(n -> SQLHelper.delimited(LocaleUtils.localizedEntityName((String)n))).orElseGet(() -> SqlMapping.plainTableName(LocaleUtils.localizedEntityName((CdsEntity)entity)));
    }

    private boolean uppercaseOnly(String n) {
        return n.equals(n.toUpperCase(Locale.US));
    }

    private CdsEntity asEntity() {
        if (!(this.rowType instanceof CdsEntity)) {
            throw new IllegalStateException(this.rowType.getQualifiedName() + "is no entity");
        }
        return (CdsEntity)this.rowType;
    }

    private Optional<String> annotatedName() {
        return this.rowType.findAnnotation(CDS_PERSISTENCE_NAME).map(CdsAnnotation::getValue);
    }

    public static String plainTableName(String qualifiedEntityName) {
        return qualifiedEntityName.replace(".", "_");
    }

    public String columnName(String elementName) {
        return this.rowType.findElement(elementName).map(SqlMapping::columnName).orElseGet(() -> SqlMapping.underscoreSeparated((CqnElementRef)ElementRefImpl.parse((String)elementName)));
    }

    public String columnName(CqnElementRef ref) {
        return this.columnName(SqlMapping.underscoreSeparated(ref));
    }

    public static String columnName(CdsElement element) {
        Optional persistenceName = element.findAnnotation(CDS_PERSISTENCE_NAME);
        return persistenceName.map(a -> SQLHelper.delimited((String)a.getValue())).orElse(element.getName());
    }

    private static String underscoreSeparated(CqnElementRef ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("_"));
    }

    public CdsStructuredType getRowType() {
        return this.rowType;
    }

    public String jsonObjectPath(CqnElementRef ref) {
        return ref.segments().stream().map(seg -> "\"" + seg.id() + "\"").collect(Collectors.joining("."));
    }
}

