/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepUpdateSplitter {
    private static final Logger logger = LoggerFactory.getLogger(DeepUpdateSplitter.class);
    private final CdsDataStore dataStore;
    private final SessionContext session;
    private CdsEntity entity;
    private EntityCascader.EntityOperations operations;

    public DeepUpdateSplitter(CdsDataStore dataStore) {
        this.dataStore = dataStore;
        this.session = dataStore.getSessionContext();
    }

    public EntityCascader.EntityOperations computeOperations(CdsEntity targetEntity, CqnUpdate update, Map<String, Object> targetKeys) {
        this.entity = targetEntity;
        this.operations = new EntityCascader.EntityOperations();
        this.operations.entries(update.entries());
        StructuredType<?> path = DeepUpdateSplitter.targetRef(update);
        List<Map<String, Object>> updateEntries = this.determineUpdateEntries(targetKeys, path);
        for (Map<String, Object> entry : updateEntries) {
            EntityCascader.EntityKeys entityId = EntityCascader.EntityKeys.keys(this.entity, entry);
            this.operations.add(EntityCascader.EntityOperation.root(entityId, this.session).update(entry, Collections.emptyMap()));
        }
        if (!updateEntries.isEmpty()) {
            this.entity.associations().forEach(assoc -> this.cascade(path, (CdsElement)assoc, updateEntries));
        }
        return this.operations;
    }

    private List<Map<String, Object>> determineUpdateEntries(Map<String, Object> targetKeys, StructuredType<?> path) {
        Set<String> targetKeyElements;
        Set missingKeys;
        Set<String> keyElements = DeepUpdateSplitter.keyNames(this.entity);
        if (!CqnStatementUtils.hasInfixFilter((CqnReference)path.asRef())) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
            if (this.entriesContainValuesFor(keyElements)) {
                return this.operations.entries();
            }
        }
        if (!this.entriesContainValuesFor(missingKeys = Sets.filter(keyElements, arg_0 -> DeepUpdateSplitter.lambda$determineUpdateEntries$2(targetKeyElements = targetKeys.keySet(), arg_0)))) {
            return this.selectKeyValues(path, missingKeys);
        }
        return this.evaluateFilter(path, targetKeys, keyElements);
    }

    private boolean entriesContainValuesFor(Set<String> elements) {
        return this.operations.entries().stream().allMatch(e -> e.keySet().containsAll(elements));
    }

    private List<Map<String, Object>> selectKeyValues(StructuredType<?> path, Set<String> missingKeys) {
        if (this.operations.entries().size() == 1) {
            logger.warn("Update data is missing key values of entity {}. Executing query to determine key values.", (Object)this.entity.getQualifiedName());
            Select select = Select.from(path).columns(missingKeys.stream().map(CQL::get));
            Result result = this.dataStore.execute((CqnSelect)select, new Object[0]);
            Map<String, Object> singleEntry = this.operations.entries().get(0);
            ArrayList<Map<String, Object>> updateEntries = new ArrayList<Map<String, Object>>();
            if (result.rowCount() == 1L) {
                Row keyValues = result.single();
                singleEntry.putAll((Map<String, Object>)keyValues);
                updateEntries.add(singleEntry);
            } else if (result.rowCount() > 1L) {
                result.forEach(row -> row.putAll(DataUtils.copyMap((Map)singleEntry)));
                updateEntries.addAll(result.list());
            }
            return updateEntries;
        }
        throw new CdsDataException("Update data is missing key values " + missingKeys + " of entity " + this.entity);
    }

    private List<Map<String, Object>> evaluateFilter(StructuredType<?> path, Map<String, Object> targetKeys, Set<String> keyElements) {
        logger.debug("Executing query to evaluate update filter condition {}", path);
        if (!targetKeys.isEmpty()) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
        }
        ArrayList<Map<String, Object>> updateEntries = new ArrayList<Map<String, Object>>();
        Map<Integer, Row> entityKeys = this.selectKeysMatchingPathFilter(path, keyElements, this.operations.entries());
        Map updateData = this.operations.entries().stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.hash(row, keyElements), Function.identity()));
        entityKeys.forEach((hash, key) -> updateEntries.add((Map<String, Object>)updateData.get(hash)));
        logger.debug("Update filter condition fulfilled by {} entities", (Object)entityKeys.size());
        return updateEntries;
    }

    private static void addKeyValues(CdsEntity entity, Map<String, Object> keyValues, Map<String, Object> target) {
        keyValues.forEach((key, valInRef) -> {
            Object valInData = target.put((String)key, valInRef);
            if (valInData != null && !valInData.equals(valInRef)) {
                throw new CdsDataException("Values for key element '" + key + "' in update data do not match values in update ref or where clause");
            }
        });
        target.putAll(Maps.filterValues((Map)DataUtils.keyValues((CdsEntity)entity, target), v -> !Objects.isNull(v)));
    }

    private static StructuredType<?> targetRef(CqnUpdate update) {
        if (!CqnStatementUtils.containsPathExpression((Optional)update.where())) {
            return CqnStatementUtils.targetRef((CqnUpdate)update);
        }
        throw new UnsupportedOperationException("Deep updates with path in where clause are not supported");
    }

    private Map<Integer, Row> selectKeysMatchingPathFilter(StructuredType<?> path, Set<String> keys, Iterable<Map<String, Object>> keyValueSets) {
        Select select = Select.from(path).columns(keys.stream().map(CQL::get)).byParams(keys);
        Result entries = this.dataStore.execute((CqnSelect)select, keyValueSets);
        return entries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.hash((Map<String, Object>)row, keys), Function.identity()));
    }

    private void cascade(StructuredType<?> path, CdsElement assoc, List<Map<String, Object>> entries) {
        Iterable updateEntries = Iterables.filter(entries, e -> e.containsKey(assoc.getName()));
        if (!Iterables.isEmpty((Iterable)updateEntries)) {
            CdsEntity targetEntity = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).getTarget();
            if (CdsModelUtils.isSingleValued((CdsType)assoc.getType())) {
                this.toOne(path, assoc, targetEntity, updateEntries);
            } else {
                this.toMany(path, assoc, targetEntity, updateEntries);
            }
        }
    }

    private void toOne(StructuredType<?> path, CdsElement assoc, CdsEntity targetEntity, Iterable<Map<String, Object>> parentEntries) {
        CdsEntity parentEntity = (CdsEntity)assoc.getDeclaringType();
        boolean reverseMapped = CdsModelUtils.isReverseAssociation((CdsElement)assoc);
        Set<String> parentKeys = DeepUpdateSplitter.keyNames(parentEntity);
        Map<Integer, Row> expandedParentEntries = this.selectPathExpandToOneTargetKeys(path, assoc, reverseMapped, parentKeys, parentEntries);
        ArrayList<Map> targetUpdateEntries = new ArrayList<Map>(Iterables.size(parentEntries));
        for (Map<String, Object> parentUpdateEntry : parentEntries) {
            Row parentEntry = expandedParentEntries.getOrDefault(DeepUpdateSplitter.hash(parentUpdateEntry, parentKeys), RowImpl.row(Collections.emptyMap()));
            Map targetEntry = (Map)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)parentEntry);
            Map targetUpdateEntry = (Map)DeepUpdateSplitter.getDataFor(assoc, parentUpdateEntry);
            if (targetEntry != null && !targetEntry.isEmpty()) {
                if (targetUpdateEntry == null) {
                    this.remove(assoc, reverseMapped, targetEntity, Collections.singletonList(targetEntry));
                } else {
                    EntityCascader.EntityOperation op = this.update(targetEntity, targetEntry, targetUpdateEntry, Collections.emptyMap());
                    DeepUpdateSplitter.assertCascading(op, assoc);
                    this.operations.add(op);
                    targetUpdateEntries.add(targetUpdateEntry);
                }
            } else if (targetUpdateEntry != null) {
                boolean generatedKey = DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, (Map)targetUpdateEntry);
                Map<String, Object> refValuesToParent = Collections.emptyMap();
                if (reverseMapped) {
                    refValuesToParent = this.fkValues(assoc, reverseMapped, parentUpdateEntry);
                } else if (generatedKey) {
                    EntityCascader.EntityKeys parentKeyValues = EntityCascader.EntityKeys.keys(parentEntity, parentUpdateEntry);
                    Map<String, Object> targetRefValues = this.fkValues(assoc, reverseMapped, targetUpdateEntry);
                    this.operations.add(this.update(parentEntity, (Map<String, Object>)((Object)parentKeyValues), new HashMap<String, Object>(), targetRefValues));
                }
                this.operations.add(this.xsert(assoc, targetEntity, targetUpdateEntry, refValuesToParent));
                targetUpdateEntries.add(targetUpdateEntry);
            }
            targetEntity.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<Map<String, Object>>)targetUpdateEntries));
        }
    }

    private Map<Integer, Row> selectPathExpandToOneTargetKeys(StructuredType<?> path, CdsElement assoc, boolean reverseMapped, Set<String> parentKeys, Iterable<Map<String, Object>> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        List slis = parentKeys.stream().map(CQL::get).collect(Collectors.toList());
        Set<String> refElements = DeepUpdateSplitter.refElements(assoc, reverseMapped);
        CdsModelUtils.targetKeys((CdsElement)assoc).forEach(refElements::add);
        slis.add(CQL.to((String)assoc.getName()).expand(refElements.toArray(new String[refElements.size()])));
        Select select = Select.from(path).columns(slis).byParams(parentKeys);
        Result targetEntries = this.dataStore.execute((CqnSelect)select, keyValueSets);
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.hash((Map<String, Object>)row, parentKeys), Function.identity()));
    }

    private Map<String, Object> fkValues(CdsElement assoc, boolean reverseMapped, Map<String, Object> data) {
        return new OnConditionAnalyzer(assoc, reverseMapped, this.session).getFkValues(data);
    }

    private void toMany(StructuredType<?> path, CdsElement assoc, CdsEntity targetEntity, Iterable<Map<String, Object>> parentEntries) {
        boolean reverseMapped = true;
        Set<String> parentKeys = DeepUpdateSplitter.keyNames((CdsEntity)assoc.getDeclaringType());
        Set targetKeys = CdsModelUtils.targetKeys((CdsElement)assoc);
        targetKeys.remove("IsActiveEntity");
        Map<Integer, Row> targetEntries = this.selectTargetEntries(assoc, parentKeys, targetKeys, parentEntries);
        ArrayList<HashMap<String, Object>> updateEntries = new ArrayList<HashMap<String, Object>>(Iterables.size(parentEntries));
        for (Map<String, Object> parentEntry : parentEntries) {
            List targetUpdateEntries = (List)DeepUpdateSplitter.getDataFor(assoc, parentEntry);
            if (targetUpdateEntries == null) {
                throw new CdsDataException("Value for to-many association '" + assoc.getDeclaringType() + "." + assoc + "' must not be null.");
            }
            Map parentRefValues = new OnConditionAnalyzer(assoc, true, this.session).getFkValues(parentEntry);
            if (parentRefValues.values().contains(null)) {
                throw new CdsDataException("Values of ref elements " + parentRefValues.keySet() + " for mapping " + targetEntity + " to " + assoc.getDeclaringType() + " cannot be determined from update data.");
            }
            for (Map updateEntry : targetUpdateEntries) {
                boolean generatedKey;
                HashMap<String, Object> updateEntryWithFks = new HashMap<String, Object>(updateEntry);
                updateEntryWithFks.putAll(parentRefValues);
                boolean targetPresent = targetEntries.remove(DeepUpdateSplitter.hash(updateEntryWithFks, targetKeys)) != null;
                boolean bl = generatedKey = !targetPresent && DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, (Map)updateEntry);
                if (generatedKey) {
                    updateEntryWithFks.putAll(updateEntry);
                }
                EntityCascader.EntityKeys targetId = EntityCascader.EntityKeys.keys(targetEntity, updateEntryWithFks);
                EntityCascader.EntityOperation operation = generatedKey ? EntityCascader.EntityOperation.insert(targetId, updateEntry, parentRefValues, this.session) : (targetPresent ? EntityCascader.EntityOperation.nop(targetId, this.session).update(updateEntry, Collections.emptyMap()) : this.xsert(assoc, targetEntity, updateEntry, parentRefValues));
                DeepUpdateSplitter.assertCascading(operation, assoc);
                this.operations.add(operation);
                updateEntries.add(updateEntryWithFks);
            }
        }
        this.remove(assoc, true, targetEntity, targetEntries.values());
        targetEntity.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<Map<String, Object>>)updateEntries));
    }

    private Map<Integer, Row> selectTargetEntries(CdsElement assoc, Set<String> parentKeys, Set<String> targetKeys, Iterable<Map<String, Object>> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        StructuredType path = CQL.entity((String)assoc.getDeclaringType().getQualifiedName()).filterByParams(parentKeys).to(assoc.getName());
        Select select = Select.from((StructuredType)path).columns(targetKeys.stream().map(CQL::get));
        Result targetEntries = this.dataStore.execute((CqnSelect)select, keyValueSets);
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.hash((Map<String, Object>)row, targetKeys), Function.identity()));
    }

    private EntityCascader.EntityOperation update(CdsEntity target, Map<String, Object> entry, Map<String, Object> updateData, Map<String, Object> fkValues) {
        EntityCascader.EntityOperation op = EntityCascader.EntityOperation.nop(EntityCascader.EntityKeys.keys(target, entry), entry, this.session).update(updateData, fkValues);
        updateData.putAll((Map<String, Object>)((Object)op.targetKeys()));
        return op;
    }

    private void remove(CdsElement association, boolean reverseMapped, CdsEntity targetEntity, Collection<? extends Map<String, Object>> keyValues) {
        if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)association)) {
            keyValues.forEach(k -> {
                EntityCascader.EntityKeys key = EntityCascader.EntityKeys.keys(targetEntity, k);
                this.operations.add(EntityCascader.EntityOperation.delete(key, this.session));
                EntityCascader.cascadeDelete(this.dataStore, key).forEach(this.operations::add);
            });
        } else if (reverseMapped) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
            Set<String> parentRefElements = DeepUpdateSplitter.refElements(association, reverseMapped);
            keyValues.forEach(k -> this.operations.add(EntityCascader.EntityOperation.nop(EntityCascader.EntityKeys.keys(targetEntity, k), this.session).updateToNull(parentRefElements)));
        }
    }

    private static Set<String> keyNames(CdsEntity entity) {
        Set keyElements = CdsModelUtils.keyNames((CdsStructuredType)entity);
        keyElements.remove("IsActiveEntity");
        return keyElements;
    }

    private EntityCascader.EntityOperation xsert(CdsElement association, CdsEntity entity, Map<String, Object> entityData, Map<String, Object> fkValues) {
        HashMap<String, Object> data = new HashMap<String, Object>(entityData);
        data.putAll(fkValues);
        EntityCascader.EntityKeys targetEntity = EntityCascader.EntityKeys.keys(entity, data);
        boolean insert = CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)association);
        boolean update = CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)association);
        if (insert && update) {
            return EntityCascader.EntityOperation.upsert(targetEntity, entityData, fkValues, this.session);
        }
        if (insert) {
            return EntityCascader.EntityOperation.insert(targetEntity, entityData, fkValues, this.session);
        }
        if (update) {
            return EntityCascader.EntityOperation.nop(targetEntity, this.session).update(entityData, fkValues);
        }
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        throw new CdsDataException(String.format("UPSERT entity '%s' via association '%s.%s' is not allowed. The association does not cascade insert or update.", target, association.getDeclaringType(), association));
    }

    private static void assertCascading(EntityCascader.EntityOperation op, CdsElement association) {
        if (op.operation() == EntityCascader.EntityOperation.Operation.UPDATE) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
        } else if (op.operation() == EntityCascader.EntityOperation.Operation.INSERT) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
        } else if (op.operation() == EntityCascader.EntityOperation.Operation.UPSERT) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
        } else if (op.operation() == EntityCascader.EntityOperation.Operation.DELETE) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.DELETE, association);
        }
    }

    private static void assertCascading(CdsModelUtils.CascadeType cascadeType, CdsElement association) {
        if (!CdsModelUtils.isCascading((CdsModelUtils.CascadeType)cascadeType, (CdsElement)association)) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            throw new CdsDataException(String.format("%s entity '%s' via association '%s.%s' is not allowed. The association does not cascade %s.", cascadeType.name(), target, association.getDeclaringType(), association, cascadeType));
        }
    }

    private static int hash(Map<String, Object> values, Set<String> keys) {
        return Maps.filterKeys(values, keys::contains).hashCode();
    }

    private static Set<String> refElements(CdsElement assoc, boolean reverseMapped) {
        HashMap mapping = new HashMap();
        new OnConditionAnalyzer(assoc, reverseMapped).getFkMapping().forEach((fk, val) -> {
            if (val.isRef() && !val.asRef().firstSegment().startsWith("$")) {
                mapping.put(fk, val.asRef().lastSegment());
            }
        });
        if (reverseMapped) {
            return new HashSet<String>(mapping.keySet());
        }
        return new HashSet<String>(mapping.values());
    }

    public static <T> T getDataFor(CdsElement assoc, Map<String, Object> data) {
        return (T)DataUtils.getOrDefault(data, (String)assoc.getName(), null);
    }

    private static /* synthetic */ boolean lambda$determineUpdateEntries$2(Set targetKeyElements, String k) {
        return !targetKeyElements.contains(k);
    }
}

