/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubQuery;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;

public class MatchPredicateNormalizer
implements Modifier {
    private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
    private final CdsModel model;
    private final CdsStructuredType target;

    public MatchPredicateNormalizer(CdsModel model, CdsStructuredType target) {
        this.model = model;
        this.target = target;
    }

    public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
        Iterator iter = ref.segments().iterator();
        RefSegment seg = (RefSegment)iter.next();
        CdsStructuredType rowType = this.model.getStructuredType(seg.id());
        this.normalizeSegment(seg, rowType);
        while (iter.hasNext()) {
            seg = (RefSegment)iter.next();
            rowType = MatchPredicateNormalizer.navigate(rowType, seg.id());
            this.normalizeSegment(seg, rowType);
        }
        return ref;
    }

    public Predicate match(StructuredTypeRef ref, Predicate predicate, CqnMatchPredicate.Quantifier quantifier) {
        CdsElement association = this.getAssociation((CqnStructuredTypeRef)ref);
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        StructuredTypeRef from = this.absoluteRef(target, ref);
        CqnPredicate where = this.innerToOuter(association);
        if (predicate != null) {
            predicate = this.normalize((CdsStructuredType)target, (CqnPredicate)predicate);
            if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                predicate = predicate.not();
            }
            where = Conjunction.and((CqnPredicate)where, (CqnPredicate)predicate);
        }
        Select subquery = Select.from((CqnStructuredTypeRef)from).where(where);
        ExistsSubQuery exists = new ExistsSubQuery((CqnSelect)subquery);
        if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
            return exists.not();
        }
        return exists;
    }

    private CqnPredicate innerToOuter(final CdsElement association) {
        CqnPredicate on = this.associationAnalyzer.getOnCondition(association);
        Modifier m = new Modifier(){

            public Value<?> ref(ElementRef<?> ref) {
                LinkedList<RefSegment> segments = new LinkedList<RefSegment>(ref.segments());
                if (ref.firstSegment().equals(association.getName())) {
                    segments.remove(0);
                } else {
                    segments.add(0, RefSegmentImpl.refSegment((String)"$outer"));
                }
                return ElementRefImpl.element(segments);
            }
        };
        on = ExpressionVisitor.copy((CqnPredicate)on, (Modifier)m);
        return on;
    }

    private StructuredTypeRef absoluteRef(final CdsEntity target, StructuredTypeRef ref) {
        StructuredTypeRef from = ExpressionVisitor.copy((CqnStructuredTypeRef)ref, (Modifier)new Modifier(){

            public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                ref.rootSegment().id(target.getQualifiedName());
                return ref;
            }
        });
        return from;
    }

    private void normalizeSegment(RefSegment seg, CdsStructuredType rowType) {
        seg.filter().ifPresent(f -> seg.filter((CqnPredicate)this.normalize(rowType, (CqnPredicate)f)));
    }

    private Predicate normalize(CdsStructuredType rowType, CqnPredicate pred) {
        return ExpressionVisitor.copy((CqnPredicate)pred, (Modifier)new MatchPredicateNormalizer(this.model, rowType));
    }

    private CdsElement getAssociation(CqnStructuredTypeRef ref) {
        String path;
        CqnReference.Segment segment;
        CdsElement element;
        CdsType elementType;
        CdsStructuredType rowType = this.target;
        String root = rowType.getQualifiedName();
        Iterator iter = ref.segments().iterator();
        while ((elementType = (element = rowType.getElement((segment = (CqnReference.Segment)iter.next()).id())).getType()).isStructured()) {
            rowType = (CdsStructuredType)elementType.as(CdsStructuredType.class);
            if (iter.hasNext()) continue;
        }
        if (!elementType.isAssociation()) {
            path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
            String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", root, path);
            throw new CqnValidationException(message);
        }
        if (iter.hasNext()) {
            path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
            String message = MessageFormat.format("The reference {0}.{1} navigates multiple associations and can''t be used with the anyMatch predicate.", root, path);
            throw new UnsupportedOperationException(message);
        }
        return element;
    }

    private static CdsStructuredType navigate(CdsStructuredType rowType, String id) {
        CdsType type = rowType.getElement(id).getType();
        if (type.isStructured()) {
            return (CdsStructuredType)type.as(CdsStructuredType.class);
        }
        if (type.isAssociation()) {
            return ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
        }
        String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", rowType.getQualifiedName(), id);
        throw new CqnValidationException(message);
    }
}

