/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsException;
import com.sap.cds.impl.Lazy;
import com.sap.cds.impl.LazyResultImpl;
import com.sap.cds.impl.LazyRowImpl;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssociationLoader {
    private final CdsDataStore dataStore;
    private final CdsStructuredType root;
    private final Map<CqnSelectListValue, Object> rootValues = new HashMap<CqnSelectListValue, Object>();

    public AssociationLoader(CdsDataStore dataStore, CdsStructuredType root) {
        this.dataStore = dataStore;
        this.root = root;
    }

    public void addValueOfRootEntity(CqnSelectListValue slv, Object value) {
        if (value != null && slv.value().isRef() && slv.value().asRef().segments().size() == 1) {
            this.rootValues.put(slv, value);
        }
    }

    public void expand(CqnExpand expand, Map<String, Object> row) {
        boolean lazy = ((ExpandBuilder)expand).lazy();
        this.expand(this.stream(expand.ref()), expand.items(), expand.orderBy(), expand.top(), expand.skip(), expand.alias(), row, lazy);
    }

    public void expand(Stream<CqnStructuredTypeRef> paths, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip, Optional<String> alias, Map<String, Object> row, boolean lazy) {
        if (this.dataStore != null) {
            List p = paths.collect(Collectors.toList());
            this.injectors().forEach(i -> ((LazyAssociationLoaderInjector)i).injectInto((Map<String, Object>)row, p, (List<CqnSelectListItem>)slis, (List<CqnSortSpecification>)orderBy, top, skip, (Optional<String>)alias, lazy));
        }
    }

    private Stream<CqnStructuredTypeRef> stream(CqnStructuredTypeRef prefix) {
        if (prefix.segments().size() == 1 && ((CqnReference.Segment)prefix.segments().get(0)).id().equals("*")) {
            return this.root.associations().map(a -> StructuredTypeRefImpl.typeRef((String)a.getName()));
        }
        return Stream.of(prefix);
    }

    private Stream<LazyAssociationLoaderInjector> injectors() {
        HashMap keys = new HashMap();
        this.rootValues.forEach((sli, value) -> {
            Optional<CdsElement> keyElement = this.getKeyElement((CqnSelectListItem)sli);
            keyElement.ifPresent(key -> {
                CdsEntity declaringEntity = (CdsEntity)key.getDeclaringType();
                keys.computeIfAbsent(declaringEntity, e -> new HashMap()).put(key.getName(), value);
            });
        });
        return keys.entrySet().stream().map(e -> new LazyAssociationLoaderInjector((CdsEntity)e.getKey(), (Map)e.getValue()));
    }

    private Optional<CdsElement> getKeyElement(CqnSelectListItem sli) {
        KeyFilter keyFilter = new KeyFilter();
        sli.accept((CqnVisitor)keyFilter);
        return keyFilter.keyElement();
    }

    private class KeyFilter
    implements CqnVisitor {
        private CdsElement keyElement;

        private KeyFilter() {
        }

        public void visit(CqnElementRef ref) {
            CdsElement e = CdsModelUtils.element((CdsStructuredType)AssociationLoader.this.root, (CqnElementRef)ref);
            if (e != null && e.isKey()) {
                this.keyElement = e;
            }
        }

        Optional<CdsElement> keyElement() {
            return Optional.ofNullable(this.keyElement);
        }
    }

    private class LazyAssociationLoaderInjector {
        private CdsEntity entity;
        private Map<String, Object> keyValues;

        LazyAssociationLoaderInjector(CdsEntity entity, Map<String, Object> keyValues) {
            this.entity = entity;
            this.keyValues = keyValues;
        }

        private void injectInto(Map<String, Object> row, Collection<CqnStructuredTypeRef> paths, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip, Optional<String> alias, boolean lazy) {
            paths.forEach(path -> this.injectInto(row, this.relativePath(this.entity, (CqnStructuredTypeRef)path), slis, orderBy, top, skip, alias, lazy));
        }

        private void injectInto(Map<String, Object> row, CqnStructuredTypeRef path, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip, Optional<String> alias, boolean lazy) {
            CqnSelect query = this.query(path, slis, orderBy, top, skip);
            Lazy loader = this.singleValued(this.entity, path) ? new LazyRowImpl(AssociationLoader.this.dataStore, query) : new LazyResultImpl(AssociationLoader.this.dataStore, query);
            String displayName = alias.orElse(path.lastSegment());
            if (lazy) {
                row.put(displayName, loader);
            } else {
                row.put(displayName, loader.loadData());
            }
        }

        private CqnStructuredTypeRef relativePath(CdsEntity entity, CqnStructuredTypeRef path) {
            if (!AssociationLoader.this.root.getQualifiedName().equals(entity.getQualifiedName())) {
                ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>();
                CdsStructuredType e = AssociationLoader.this.root;
                boolean add = false;
                for (CqnReference.Segment seg : path.segments()) {
                    if (!e.findAssociation(seg.id()).isPresent()) continue;
                    e = e.getTargetOf(seg.id());
                    if (add) {
                        segments.add(seg);
                        continue;
                    }
                    if (!e.getQualifiedName().equals(entity.getQualifiedName())) continue;
                    add = true;
                }
                if (segments.isEmpty()) {
                    throw new IllegalStateException("Cannot resolve path: " + entity + "." + path);
                }
                return StructuredTypeRefImpl.typeRef(segments);
            }
            return path;
        }

        private boolean singleValued(CdsEntity entity, CqnStructuredTypeRef path) {
            CdsEntity e = entity;
            CdsElement association = null;
            for (CqnReference.Segment seg : path.segments()) {
                String assocName = seg.id();
                association = e.getAssociation(assocName);
                e = e.getTargetOf(assocName);
            }
            if (association == null) {
                throw new CdsException("Missing association for Entity " + e.getName() + ", under Path " + path.toJson() + ".");
            }
            return CdsModelUtils.isSingleValued((CdsType)association.getType());
        }

        private CqnSelect query(CqnStructuredTypeRef path, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip) {
            if (!this.keyValues.keySet().containsAll(CdsModelUtils.keyNames((CdsStructuredType)this.entity))) {
                throw new CdsException("Missing key values for entity " + this.entity.getQualifiedName() + ". Please add all keys to the projection.");
            }
            ArrayList<RefSegment> segments = new ArrayList<RefSegment>();
            segments.add(RefSegmentImpl.refSegment((String)this.entity.getQualifiedName(), (CqnPredicate)ExpressionImpl.matching(this.keyValues)));
            segments.addAll(path.segments());
            SelectBuilder query = SelectBuilder.from((CqnStructuredTypeRef)StructuredTypeRefImpl.typeRef(segments)).columns(slis).orderBy(orderBy).limit(top, skip);
            return query;
        }
    }
}

