/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.RuntimeCompatibilityMode;
import com.sap.cds.jdbc.SystemPropertyDataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsVersion;
import com.sap.cds.util.CdsModelUtils;

public class ContextImpl
implements Context {
    private final CdsModel cdsModel;
    private final DbContext dbContext;
    private final CdsVersion compilerVersion;
    private final RuntimeCompatibilityMode runtimeMode;
    private final DataStoreConfiguration dataStoreConfiguration;
    private final SessionContext sessionContext = SessionContext.create();

    @Override
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext.from(sessionContext);
    }

    private ContextImpl(CdsModel model, DbContext dbContext, SessionContext sessionContext, DataStoreConfiguration dataStoreConfiguration) {
        this.cdsModel = model;
        this.dbContext = dbContext;
        this.sessionContext.from(sessionContext);
        this.compilerVersion = CdsModelUtils.compilerVersion((CdsModel)model);
        this.runtimeMode = new RuntimeCompatibilityMode(this.compilerVersion.major());
        this.dataStoreConfiguration = dataStoreConfiguration;
    }

    @VisibleForTesting
    public static Context context(CdsModel model, DbContext dbContext, SessionContext sessionContext) {
        return ContextImpl.context(model, dbContext, sessionContext, new SystemPropertyDataStoreConfiguration());
    }

    public static Context context(CdsModel model, DbContext dbContext, SessionContext sessionContext, DataStoreConfiguration dataStoreConfiguration) {
        return new ContextImpl(model, dbContext, sessionContext, dataStoreConfiguration);
    }

    public static Context context(CdsModel model, DbContext dbContext) {
        return ContextImpl.context(model, dbContext, new SystemPropertyDataStoreConfiguration());
    }

    public static Context context(CdsModel model, DbContext dbContext, DataStoreConfiguration dataStoreConfiguration) {
        return new ContextImpl(model, dbContext, SessionContext.create(), dataStoreConfiguration);
    }

    @Override
    public CdsModel getCdsModel() {
        return this.cdsModel;
    }

    @Override
    public DbContext getDbContext() {
        return this.dbContext;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public CdsVersion getCdsCompilerVersion() {
        return this.compilerVersion;
    }

    @Override
    public RuntimeCompatibilityMode getRuntimeMode() {
        return this.runtimeMode;
    }

    @Override
    public DataStoreConfiguration getDataStoreConfiguration() {
        return this.dataStoreConfiguration;
    }
}

