/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.DeleteStatementBuilder;
import com.sap.cds.impl.sql.InsertStatementBuilder;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.UpdateStatementBuilder;
import com.sap.cds.jdbc.hana.docstore.DocStoreDeleteStatementBuilder;
import com.sap.cds.jdbc.hana.docstore.DocStoreSelectStatementBuilder;
import com.sap.cds.jdbc.hana.docstore.DocStoreUpdateStatementBuilder;
import com.sap.cds.jdbc.hana.docstore.DocStoreUtils;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsModel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;

public class JdbcDataSourceAdapter
implements SQLDataSourceAdapter {
    private static final ArrayDeque<QatSelectableNode> ROOT = new ArrayDeque();
    private final Context context;
    private final DocStoreUtils docStoreUtils;

    public JdbcDataSourceAdapter(Context context) {
        this.context = context;
        this.docStoreUtils = new DocStoreUtils(context.getCdsModel());
    }

    private SQLStatementBuilder.SQLStatement appendCollation(SQLStatementBuilder.SQLStatement sqlStatement, CqnStatement statement) {
        Locale locale = this.context.getSessionContext().getLocale();
        Optional collateClause = LocaleUtils.collateClauseIsNeeded((CdsModel)this.context.getCdsModel(), (CqnStatement)statement, (Locale)locale) ? this.context.getDbContext().getStatementResolver().collateClause(statement, locale) : Optional.empty();
        if (collateClause.isPresent()) {
            String sql = String.join((CharSequence)" ", sqlStatement.sql(), (CharSequence)collateClause.get());
            return new SQLStatementBuilder.SQLStatement(sql, sqlStatement.params());
        }
        return sqlStatement;
    }

    @Override
    public SQLStatementBuilder.SQLStatement process(CqnStatement statement) {
        if (this.docStoreUtils.targetsDocStore(statement)) {
            return this.getDocStoreSqlStatement(statement);
        }
        return this.getColumnStoreSqlStatement(statement);
    }

    private SQLStatementBuilder.SQLStatement getDocStoreSqlStatement(CqnStatement statement) {
        this.assertThatDocStoreSupportIsEnabled();
        if (statement.isSelect()) {
            return new DocStoreSelectStatementBuilder(this.context, statement.asSelect()).build();
        }
        if (statement.isInsert()) {
            return DocStoreUtils.getDocStoreInsertStatement(statement.asInsert(), this.context);
        }
        if (statement.isUpdate()) {
            return new DocStoreUpdateStatementBuilder(this.context, statement.asUpdate()).build();
        }
        if (statement.isDelete()) {
            return new DocStoreDeleteStatementBuilder(this.context, statement.asDelete()).build();
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    private SQLStatementBuilder.SQLStatement getColumnStoreSqlStatement(CqnStatement statement) {
        if (statement.isSelect()) {
            CqnSelect select = statement.asSelect();
            return this.appendCollation(new SelectStatementBuilder(this.context, new ArrayList<PreparedCqnStmt.Parameter>(), select, ROOT).build(), (CqnStatement)select);
        }
        if (statement.isInsert()) {
            return new InsertStatementBuilder(this.context, statement.asInsert()).build();
        }
        if (statement.isUpdate()) {
            return this.appendCollation(new UpdateStatementBuilder(this.context, statement.asUpdate()).build(), (CqnStatement)statement.asUpdate());
        }
        if (statement.isDelete()) {
            return this.appendCollation(new DeleteStatementBuilder(this.context, statement.asDelete()).build(), (CqnStatement)statement.asDelete());
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    public void assertThatDocStoreSupportIsEnabled() {
        if (!this.context.getDataStoreConfiguration().getProperty("cds.sql.hana.docstore", false)) {
            throw new UnsupportedOperationException("Can't handle an entity annotated as doc-store enabled: DocStore integration is not enabled.");
        }
    }
}

