/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.jdbc.spi.FunctionMapper;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class FunctionMapperImpl
implements FunctionMapper {
    public String toSql(String cqnFunc, List<String> args) {
        String func;
        switch (func = cqnFunc.toLowerCase(Locale.US)) {
            case "countdistinct": {
                return "COUNT(DISTINCT " + args.get(0) + ")";
            }
            case "tolower": {
                return this.genericFuncToSql("LOWER", args);
            }
            case "toupper": {
                return this.genericFuncToSql("UPPER", args);
            }
            case "current_date": {
                return "current_date";
            }
            case "current_time": {
                return "current_time";
            }
            case "current_timestamp": {
                return "current_timestamp";
            }
            case "singlevalue": {
                String col = args.get(0);
                return MessageFormat.format("(case when min({0}) = max({0}) then min ({0}) end)", col);
            }
            case "count": {
                if (!args.isEmpty()) break;
                return "COUNT(*)";
            }
        }
        return this.genericFuncToSql(cqnFunc, args);
    }

    protected String genericFuncToSql(String func, List<String> args) {
        return func.toUpperCase(Locale.US) + args.stream().collect(Collectors.joining(", ", "(", ")"));
    }
}

