/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.PreparedCqnStmt;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public interface SQLStatementBuilder {
    public SQLStatement build();

    public static <T> Stream<String> commaSeparated(Stream<T> stream, Function<T, String> f) {
        return stream.map(f).filter(t -> t != null).flatMap(e -> Stream.of(",", e)).skip(1L);
    }

    public static Stream<String> commaSeparated(Stream<String> stream) {
        return SQLStatementBuilder.commaSeparated(stream, v -> v);
    }

    public static class SQLStatement {
        private final String sql;
        private final List<PreparedCqnStmt.Parameter> params;

        public SQLStatement(String sql, List<PreparedCqnStmt.Parameter> params) {
            this.sql = sql;
            this.params = params;
        }

        public String sql() {
            return this.sql;
        }

        public List<PreparedCqnStmt.Parameter> params() {
            return this.params;
        }
    }
}

