/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.DbContextFactory;
import com.sap.cds.jdbc.spi.DbContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.function.Supplier;

public class DbContextFactoryRegister {
    private static final ThreadLocal<Collection<DbContextFactory>> registeredCandidates = ThreadLocal.withInitial(() -> Cds4jServiceLoader.loadAll(DbContextFactory.class));

    private DbContextFactoryRegister() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DbContext context(DataStoreConfiguration dataStoreConfiguration, Supplier<Connection> ds) {
        try (Connection conn = ds.get();){
            String dbName = conn.getMetaData().getDatabaseProductName();
            DbContext dbContext = DbContextFactoryRegister.context(dataStoreConfiguration, dbName);
            return dbContext;
        }
        catch (SQLException e) {
            throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
        }
    }

    @VisibleForTesting
    static DbContext context(DataStoreConfiguration dataStoreConfiguration, String productName) {
        return registeredCandidates.get().stream().filter(f -> f.supports(productName)).map(f -> f.create(dataStoreConfiguration)).findFirst().orElseThrow(() -> new CdsDataStoreException("Unsupported DB " + productName));
    }
}

