/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchResolver
implements SearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSearchResolver.class);
    private static final String LOCALIZED = "localized";
    protected final CdsModel model;
    protected final Locale locale;

    public AbstractSearchResolver(CdsModel cdsModel, Locale locale) {
        this.model = cdsModel;
        this.locale = locale;
    }

    protected static CqnPredicate wrapIntoExistsSubquery(CdsEntity target, CqnPredicate search, boolean ignoreLocalizedViews) {
        CqnPredicate toOuter = CqnStatementUtils.linkKeysToOuterQuery((CdsStructuredType)target);
        Select subquery = Select.from((CdsEntity)target).where(Conjunction.and((CqnPredicate)toOuter, (CqnPredicate)search));
        if (ignoreLocalizedViews) {
            ((SelectBuilder)subquery).hint("ignoreLocalizedViews", (Object)true);
        }
        ((SelectBuilder)subquery).hint("ignoreDraftSubqueries", (Object)true);
        return new ExistsSubquery((CqnSelect)subquery);
    }

    protected static boolean anyRefViaCollectionAssociation(CdsStructuredType root, Collection<ElementRef<?>> refs) {
        for (ElementRef<?> ref : refs) {
            List prefix;
            List segments = ref.segments();
            if (segments.size() <= 1 || CqnStatementUtils.isToOnePath((CdsStructuredType)root, prefix = segments.subList(0, segments.size() - 1))) continue;
            return true;
        }
        return false;
    }

    protected static CqnPredicate pushDownToExistsSubquery(CdsStructuredType targetType, CqnPredicate filter, boolean ignoreLocalizedViews) {
        if (!(targetType instanceof CdsEntity)) {
            throw new UnsupportedOperationException("A path expression used in search must originate from an entity");
        }
        CdsEntity targetEntity = (CdsEntity)targetType;
        filter = AbstractSearchResolver.wrapIntoExistsSubquery(targetEntity, filter, ignoreLocalizedViews);
        return filter;
    }

    private static List<String> segments(CqnElementRef ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.toList());
    }

    private static ElementRef<?> ref(List<String> segs) {
        return ElementRefImpl.element((String[])segs.toArray(new String[0]));
    }

    protected boolean allLocalizedElementsAreReachableViaLocalizedAssociation(CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs) {
        Set badRefs = searchableRefs.stream().filter(ref -> AbstractSearchResolver.localizedButNotReachableViaLocalizedRef(targetType, (CqnElementRef)ref)).collect(Collectors.toSet());
        if (!badRefs.isEmpty()) {
            logger.warn("Detected one or more localized elements in entity/view {} that is not reachable corresponding 'localized' association: {}. Search will fall back to LIKE and localized views.", (Object)targetType, badRefs);
            return false;
        }
        return true;
    }

    private static boolean localizedButNotReachableViaLocalizedRef(CdsStructuredType targetType, CqnElementRef ref) {
        CdsElement element = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref);
        if (!element.isLocalized()) {
            return false;
        }
        Optional localizedAssoc = ((CdsStructuredType)element.getDeclaringType().as(CdsStructuredType.class)).findAssociation(LOCALIZED);
        if (!localizedAssoc.isPresent()) {
            return true;
        }
        CdsEntity texts = ((CdsAssociationType)((CdsElement)localizedAssoc.get()).getType().as(CdsAssociationType.class)).getTarget();
        return !texts.findElement(element.getName()).isPresent();
    }

    public List<ElementRef<?>> addRefsViaLocalizedAssociation(CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs) {
        ArrayList allSearchableRefs = new ArrayList(searchableRefs);
        searchableRefs.stream().filter(ref -> CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref).isLocalized()).forEach(searchableRef -> {
            LinkedList<RefSegment> searchSegments = new LinkedList<RefSegment>(searchableRef.segments());
            searchSegments.add(searchSegments.size() - 1, CQL.refSegment((String)LOCALIZED));
            allSearchableRefs.add(CQL.get(searchSegments));
        });
        return this.deduplicate(allSearchableRefs);
    }

    protected boolean hasAliasedLocalizedElementsInView(CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs) {
        if (!(targetType instanceof CdsEntity)) {
            return false;
        }
        Optional query = ((CdsEntity)targetType).query();
        if (query.isPresent()) {
            return ((CqnSelect)query.get()).items().stream().filter(i -> i.isRef() && i.asValue().alias().isPresent()).filter(i -> this.isSearchable((CqnSelectListItem)i, searchableRefs)).map(i -> CdsModelUtils.findElement((CdsStructuredType)targetType, (CqnElementRef)i.asRef())).filter(Optional::isPresent).anyMatch(ref -> ((CdsElement)ref.get()).isLocalized());
        }
        return false;
    }

    protected boolean isSearchable(CqnSelectListItem sli, Collection<ElementRef<?>> searchableRefs) {
        return searchableRefs.stream().anyMatch(s -> s.asValue().displayName().equals(sli.asValue().displayName()));
    }

    private List<ElementRef<?>> deduplicate(List<ElementRef<?>> allSearchableRefs) {
        LinkedHashSet set = new LinkedHashSet();
        allSearchableRefs.stream().map(AbstractSearchResolver::segments).forEach(set::add);
        return set.stream().map(AbstractSearchResolver::ref).collect(Collectors.toList());
    }

    protected void resolveUsingLocalizedViewWithLike(CqnSelect select, CqnPredicate expression, CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs, boolean pushToExistsSubQuery) {
        CqnPredicate filter = CdsSearchUtils.searchToLikeExpression(searchableRefs, (CqnPredicate)expression);
        if (AbstractSearchResolver.anyRefViaCollectionAssociation(targetType, searchableRefs) || pushToExistsSubQuery) {
            filter = AbstractSearchResolver.pushDownToExistsSubquery(targetType, filter, false);
        }
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    protected void resolveUsingLocalizedAssociationWithLike(CqnSelect select, CqnPredicate expression, CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs) {
        List<ElementRef<?>> allSearchableRefs = this.addRefsViaLocalizedAssociation(targetType, searchableRefs);
        CqnPredicate filter = CdsSearchUtils.searchToLikeExpression(allSearchableRefs, (CqnPredicate)expression);
        filter = AbstractSearchResolver.pushDownToExistsSubquery(targetType, filter, true);
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    protected static class SearchMode {
        private final boolean resolveLocalizedElements;
        private final boolean useContains;
        private final boolean useExistsSubquery;

        private SearchMode(boolean resolveLocalizedElements, boolean useContains, boolean useExistsSubquery) {
            this.resolveLocalizedElements = resolveLocalizedElements;
            this.useContains = useContains;
            this.useExistsSubquery = useExistsSubquery;
        }

        public static SearchMode of(boolean useContains, boolean useExistsSubQuery, boolean resolveLocalizedElements) {
            return new SearchMode(resolveLocalizedElements, useContains, useExistsSubQuery);
        }

        public boolean isUseContains() {
            return this.useContains;
        }

        public boolean isUseExistsSubquery() {
            return this.useExistsSubquery;
        }

        public boolean isResolveLocalizedElements() {
            return this.resolveLocalizedElements;
        }
    }
}

