/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsSearchUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.Locale;

public class GenericSearchResolver
extends AbstractSearchResolver {
    public GenericSearchResolver(CdsModel cdsModel, Locale locale) {
        super(cdsModel, locale);
    }

    public GenericSearchResolver(CdsModel cdsModel) {
        this(cdsModel, null);
    }

    public CqnSelect resolve(CqnSelect select) {
        select.search().ifPresent(expression -> {
            boolean ignoreLocalizedViews;
            CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
            Collection searchableRefs = CdsSearchUtils.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
            boolean languageIsGiven = this.locale != null;
            boolean bl = ignoreLocalizedViews = languageIsGiven && LocaleUtils.hasLocalizedElements((CdsStructuredType)targetType, (Collection)searchableRefs) && this.allLocalizedElementsAreReachableViaLocalizedAssociation(targetType, searchableRefs) && !this.hasAliasedLocalizedElementsInView(targetType, searchableRefs);
            if (ignoreLocalizedViews) {
                this.resolveUsingLocalizedAssociationWithLike(select, (CqnPredicate)expression, targetType, searchableRefs);
            } else {
                this.resolveUsingLocalizedViewWithLike(select, (CqnPredicate)expression, targetType, searchableRefs, false);
            }
        });
        return select;
    }
}

