/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Arrays;
import java.util.Locale;

public class GenericTableNameResolver
implements TableNameResolver {
    private static final String DEFAULT_SUPPORTED_LOCALES = "de,fr";
    protected final DataStoreConfiguration dataStoreConfiguration;
    protected final Locale locale;

    public GenericTableNameResolver(DataStoreConfiguration dataStoreConfiguration, Locale locale) {
        this.dataStoreConfiguration = dataStoreConfiguration;
        this.locale = locale;
    }

    public String tableName(CdsEntity entity) {
        if (LocaleUtils.isLocalized((CdsEntity)entity) && this.validLocale(this.locale)) {
            String localeSpecifcViewName = LocaleUtils.localizedEntityName((String)entity.getQualifiedName(), (Locale)this.locale);
            return SqlMapping.plainTableName(localeSpecifcViewName);
        }
        return new SqlMapping((CdsStructuredType)entity).tableName();
    }

    private boolean validLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        String supportedLocales = this.dataStoreConfiguration.getProperty("supported_locales", DEFAULT_SUPPORTED_LOCALES);
        return Arrays.asList(supportedLocales.split(",")).contains(locale.getLanguage());
    }
}

