/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl;

import java.util.List;
import java.util.Map;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.cqn.CqnStatement;

public interface ConnectedClient {

	PreparedCqnStatement prepare(CqnStatement statement);

	ResultBuilder executeQuery(PreparedCqnStatement preparedStmt, Map<String, Object> cqnParameterValues,
			CdsDataStore dataStore, boolean isTransactionRequired);

	int[] executeUpdate(PreparedCqnStatement preparedStmt, List<Map<String, Object>> values);

	/**
	 * Sets a context variable at current connection. If variable is already set it
	 * will be replaced with given value.
	 *
	 * @param name  The name of the context variable to set
	 * @param value The value to set the context variable to. If the value is null,
	 *              the current value of the specified property is cleared
	 * @deprecated Use {@link #setSessionContext(SessionContext)} instead
	 */
	@Deprecated
	void setContextVariable(String name, String value);

	void setSessionContext(SessionContext session);

	/**
	 * If the current thread is associated with an active transaction it is set in
	 * rollback only mode
	 */
	void setRollbackOnly();

	Capabilities capabilities();

}
