/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsVersion;

public interface Context {

	CdsModel getCdsModel();

	DbContext getDbContext();

	SessionContext getSessionContext();

	/**
	 * Copy the values from {@code sessionContext} into current session object.
	 * 
	 * @param sessionContext the source object from which the values are copied
	 */
	void setSessionContext(SessionContext sessionContext);

	CdsVersion getCdsCompilerVersion();

	RuntimeCompatibilityMode getRuntimeMode();

	DataStoreConfiguration getDataStoreConfiguration();

	default SearchResolver getSearchResolver() {
		return getDbContext().createSearchResolver(getCdsModel(), getSessionContext().getLocale());
	}

	default TableNameResolver getTableNameResolver() {
		return getDbContext().createTableNameResolver(getSessionContext().getLocale());
	}
}
