/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;

public interface CqnValidator {

	static CqnValidator create(Context context) {
		return new CqnValidatorImpl(context.getCdsModel());
	}

	void validate(CqnSelect select);

	void validate(CqnSelect select, Capabilities capabilities);

	void validate(CqnInsert insert);

	void validate(CqnUpdate update);

	void validate(CqnDelete delete);
}
