/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.qat;

import java.util.Optional;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;

public final class QatAssociationNode extends QatEntityNode {

	private final QatAssociation association;

	public QatAssociationNode(QatNode parent, QatAssociation association, Optional<CqnPredicate> filter,
			boolean inSource) {
		super(parent, association.targetEntity(), filter, inSource);
		this.association = association;
	}

	public QatAssociation association() {
		return association;
	}

	public CdsEntity entity() {
		return association.targetEntity();
	}

	public String name() {
		return association().name();
	}

	@Override
	public void accept(QatVisitor visitor) {
		visitor.visit(this);
	}

	@Override
	public String toString() {
		return alias() + " " + association.name() + " " + children();
	}

}
