/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.sql;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnContainmentTest.Position;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class ContainsToLike {
	private static final String TOLOWER = "tolower";
	private static final char ESCAPE_CHAR = '\\';
	private static final CqnValue ESCAPE_LITERAL = CQL.constant("" + ESCAPE_CHAR);
	private static final CqnPlain LIKE = CqnPlainImpl.plain("LIKE");
	private static final CqnPlain ESCAPE = CqnPlainImpl.plain("ESCAPE");

	public static CqnPredicate transform(CqnPredicate pred) {
		return CQL.copy(pred, new Modifier() {
			@Override
			public Predicate containment(Position position, CqnValue value, CqnValue term, boolean caseInsensitive) {
				if (caseInsensitive) {
					value = CQL.func(TOLOWER, value);
					term = CQL.func(TOLOWER, term);
				}
				CqnValue pattern = escapeTerm(position, term);

				return ExpressionBuilder.create(value, LIKE, pattern, ESCAPE, ESCAPE_LITERAL).predicate();
			}
		});
	}

	private static CqnValue escapeTerm(Position position, CqnValue term) {
		return ExpressionVisitor.copy(term, new Modifier() {
			@Override
			public CqnValue literal(CqnLiteral<?> literal) {
				if (literal.isString()) {
					String term = SQLHelper.escapeLikePattern(ESCAPE_CHAR, literal.asString().value());
					switch (position) {
					case START:
						term = term + '%';
						break;
					case ANY:
						term = '%' + term + '%';
						break;
					case END:
						term = '%' + term;
						break;
					default:
						throw new IllegalArgumentException("unexpected position: " + position);
					}
					return CQL.val(term);
				} else {
					return literal;
				}
			}
		});
	}
}
