/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.sql;

import java.util.ArrayList;
import java.util.List;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt.Parameter;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.reflect.CdsEntity;

public class DeleteStatementBuilder implements SQLStatementBuilder {

	private final CqnDelete delete;
	private final String tableName;
	private final TokenToSQLTransformer toSQL;
	private final List<Parameter> params = new ArrayList<>();

	public DeleteStatementBuilder(Context context, CqnDelete delete) {
		this.delete = delete;
		CdsEntity entity = context.getCdsModel().getEntity(delete.ref().firstSegment());
		SqlMapping sqlMapping = new SqlMapping(entity);
		tableName = sqlMapping.tableName();
		toSQL = new TokenToSQLTransformer(context, sqlMapping::columnName, entity, tableName, params);
	}

	public SQLStatement build() {
		StringBuilder builder = new StringBuilder();
		builder.append("DELETE FROM ");
		builder.append(tableName);
		delete.where().map(toSQL::toSQL).ifPresent(s -> {
			builder.append(" WHERE ");
			builder.append(s);
		});

		String sql = builder.toString();

		return new SQLStatement(sql, params);
	}

}
