/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.sql;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

import com.sap.cds.impl.PreparedCqnStmt.Parameter;

public interface SQLStatementBuilder {

	public static class SQLStatement {
		private final String sql;
		private final List<Parameter> params;

		public SQLStatement(String sql, List<Parameter> params) {
			this.sql = sql;
			this.params = params;
		}

		public String sql() {
			return sql;
		}

		public List<Parameter> params() {
			return params;
		}
	}

	SQLStatement build();

	static <T> Stream<String> commaSeparated(Stream<T> stream, Function<T, String> f) {
		return stream.map(f).filter(t -> t != null).flatMap(e -> Stream.of(",", e)).skip(1);
	}

	static Stream<String> commaSeparated(Stream<String> stream) {
		return commaSeparated(stream, v -> v);
	}

}
