/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.sql;

import static com.sap.cds.impl.builder.model.ElementRefImpl.parse;
import static com.sap.cds.impl.sql.SQLHelper.param;
import static com.sap.cds.util.CdsModelUtils.element;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt.Parameter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;

public class UpsertStatementBuilder implements SQLStatementBuilder {

	private final CqnUpsert upsert;
	private final SqlMapping sqlMapping;
	private final CdsEntity entity;
	private final StatementResolver statementResolver;

	public UpsertStatementBuilder(Context context, CqnUpsert upsert) {
		this.upsert = upsert;
		this.entity = context.getCdsModel().getEntity(upsert.ref().firstSegment());
		this.sqlMapping = new SqlMapping(entity);
		this.statementResolver = context.getDbContext().getStatementResolver();
	}

	public SQLStatement build() {
		List<Parameter> params = new ArrayList<>();

		String tableName = sqlMapping.tableName();
		Stream<String> upsertColumns = upsert.elements().map(e -> {
			CqnElementRef ref = parse(e);
			CdsElement element = element(entity, ref);
			params.add(param(e, element));
			return SqlMapping.columnName(element);
		});
		Stream<String> keyColumns = entity.keyElements().map(e -> {
			return SqlMapping.columnName(e);
		});
		Stream<String> paramMarkers = upsert.elements().map(c -> "?");
		String sql = statementResolver.upsert(tableName, keyColumns, upsertColumns, paramMarkers);

		return new SQLStatement(sql, params);
	}

}
