package com.sap.cds.jdbc.generic;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;

public class GenericBinder extends AbstractValueBinder {

	public GenericBinder(int timestampFractionalSeconds) {
		super(timestampFractionalSeconds);
	}

	@Override
	protected Instant getInstant(ResultSet result, int i) throws SQLException {
		Timestamp dt = result.getTimestamp(i, UTC.get());
		return dt != null ? dt.toInstant() : null;
	}

	@Override
	protected void setInstant(PreparedStatement pstmt, int i, Instant instant) throws SQLException {
		Timestamp ts = Timestamp.from(instant);
		pstmt.setTimestamp(i, ts, UTC.get());
	}

	@Override
	protected LocalDate getLocalDate(ResultSet result, int i) throws SQLException {
		Date date = result.getDate(i, getCalendarForDefaultTimeZone());
		return date != null ? date.toLocalDate() : null;
	}

	@Override
	protected void setLocalDate(PreparedStatement pstmt, int i, LocalDate localDate) throws SQLException {
		Date date = Date.valueOf(localDate);
		pstmt.setDate(i, date, getCalendarForDefaultTimeZone());
	}

	@Override
	protected LocalTime getLocalTime(ResultSet result, int i) throws SQLException {
		Time time = result.getTime(i, getCalendarForDefaultTimeZone());
		return time != null ? time.toLocalTime() : null;
	}

	@Override
	protected void setLocalTime(PreparedStatement pstmt, int i, LocalTime localTime) throws SQLException {
		Time time = Time.valueOf(localTime);
		pstmt.setTime(i, time, getCalendarForDefaultTimeZone());
	}

	@Override
	protected Reader getLargeString(ResultSet result, int i) throws SQLException {
		return result.getCharacterStream(i);
	}

	@Override
	protected void setLargeString(PreparedStatement pstmt, int i, Reader reader) throws SQLException {
		pstmt.setCharacterStream(i, reader);
	}

	@Override
	protected InputStream getLargeBinary(ResultSet result, int i) throws SQLException {
		return result.getBinaryStream(i);
	}

	@Override
	protected void setLargeBinary(PreparedStatement pstmt, int i, InputStream stream) throws SQLException {
		pstmt.setBinaryStream(i, stream);
	}

}
