/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.generic;

import java.util.Locale;
import java.util.function.UnaryOperator;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;

public abstract class GenericDbContext implements DbContext {

	protected final DataStoreConfiguration dataStoreConfiguration;

	public GenericDbContext(DataStoreConfiguration dataStoreConfiguration) {
		this.dataStoreConfiguration = dataStoreConfiguration;
	}

	@Override
	public TableNameResolver createTableNameResolver(Locale locale) {
		return new GenericTableNameResolver(dataStoreConfiguration, locale);
	}

	@Override
	public SearchResolver createSearchResolver(CdsModel model, Locale locale) {
		return new GenericSearchResolver(model, locale);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return new GenericFunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new GenericStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new GenericExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return CdsDataStoreConnector.Capabilities.ALL;
	}

	@Override
	public UnaryOperator<CqnPredicate> getPredicateMapper() {
		return new GenericPredicateMapper();
	}

	@Override
	public ValueBinder getBinder() {
		return new GenericBinder(getCapabilities().timestampPrecision());
	}
}
