/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.generic;

import static java.util.stream.Collectors.joining;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

import com.sap.cds.jdbc.spi.FunctionMapper;

public class GenericFunctionMapper implements FunctionMapper {

	public String toSql(String cqnFunc, List<String> args) {
		String func = cqnFunc.toLowerCase(Locale.US);
		switch (func) { // NOSONAR
		case "countdistinct":
			return "COUNT(DISTINCT " + args.get(0) + ")";
		case "tolower":
			return genericFuncToSql("LOWER", args);
		case "toupper":
			return genericFuncToSql("UPPER", args);
		case "current_date":
			return "current_date";
		case "current_time":
			return "current_time";
		case "current_timestamp":
			return "current_timestamp";
		case "singlevalue":
			String col = args.get(0);
			return MessageFormat.format("(case when min({0}) = max({0}) then min ({0}) end)", col);
		case "count":
			if (args.isEmpty()) {
				return "COUNT(*)";
			}
		}
		return genericFuncToSql(cqnFunc, args);
	}

	protected String genericFuncToSql(String func, List<String> args) {
		return func.toUpperCase(Locale.US) + args.stream().collect(joining(", ", "(", ")"));
	}
}
