/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.generic;

import static com.sap.cds.impl.builder.model.ComparisonPredicate.eq;
import static com.sap.cds.impl.builder.model.ComparisonPredicate.ne;
import static com.sap.cds.ql.CQL.and;
import static com.sap.cds.ql.CQL.or;

import java.util.function.UnaryOperator;

import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate.Operator;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class GenericPredicateMapper implements UnaryOperator<CqnPredicate> {

	@Override
	public CqnPredicate apply(CqnPredicate pred) {
		Modifier m = new Modifier() {

			@Override
			public Predicate comparison(Value<?> lhs, Operator op, Value<?> rhs) {
				switch (op) {
				case IS:
					// (a = b AND a IS NOT NULL AND b IS NOT NULL) OR (a IS NULL AND b IS NULL)
					CqnPredicate bothNotNull = and(lhs.isNotNull(), rhs.isNotNull());
					CqnPredicate bothNull = and(lhs.isNull(), rhs.isNull());

					return or(and(eq(lhs, rhs), bothNotNull), bothNull);
				case IS_NOT:
					// ((a <> b OR a IS NULL OR b IS NULL) AND (a IS NOT NULL OR b IS NOT NULL))
					CqnPredicate eitherNull = or(lhs.isNull(), rhs.isNull());
					CqnPredicate eitherNotNull = or(lhs.isNotNull(), rhs.isNotNull());

					return and(or(ne(lhs, rhs), eitherNull), eitherNotNull);
				default:
					return Modifier.super.comparison(lhs, op, rhs);
				}
			}

		};
		return ExpressionVisitor.copy(pred, m);
	}
}
