/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.generic;

import static com.sap.cds.DataStoreConfiguration.SUPPORTED_LOCALES;
import static com.sap.cds.impl.localized.LocaleUtils.isLocalized;
import static com.sap.cds.impl.localized.LocaleUtils.localizedEntityName;

import java.util.Arrays;
import java.util.Locale;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.reflect.CdsEntity;

public class GenericTableNameResolver implements TableNameResolver {

	private static final String DEFAULT_SUPPORTED_LOCALES = "de,fr";
	protected final DataStoreConfiguration dataStoreConfiguration;
	protected final Locale locale;

	public GenericTableNameResolver(DataStoreConfiguration dataStoreConfiguration, Locale locale) {
		this.dataStoreConfiguration = dataStoreConfiguration;
		this.locale = locale;
	}

	@Override
	public String tableName(CdsEntity entity) {
		if (isLocalized(entity)) {
			if (validLocale(locale)) {
				String localeSpecifcViewName = localizedEntityName(entity.getQualifiedName(), locale);

				return SqlMapping.plainTableName(localeSpecifcViewName);
			}
		}

		return new SqlMapping(entity).tableName();
	}

	private boolean validLocale(Locale locale) {
		if (locale == null) {
			return false;
		}

		String supportedLocales = dataStoreConfiguration.getProperty(SUPPORTED_LOCALES, DEFAULT_SUPPORTED_LOCALES);

		return Arrays.asList(supportedLocales.split(",")).contains(locale.getLanguage());
	}
}
