/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.h2;

import java.util.List;
import java.util.Locale;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;

public class H2FunctionMapper extends GenericFunctionMapper {

	@Override
	public String toSql(String cqnFunc, List<String> args) {
		String func = cqnFunc.toLowerCase(Locale.US);
		switch (func) {
		case "current_time":
			return "cast(current_time as time)";
		default:
			return super.toSql(cqnFunc, args);
		}
	}

}
