/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana;

import static com.sap.cds.impl.localized.LocaleUtils.isLocalized;

import java.util.Locale;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.jdbc.generic.GenericTableNameResolver;
import com.sap.cds.reflect.CdsEntity;

public class HanaTableNameResolver extends GenericTableNameResolver {

	public HanaTableNameResolver(DataStoreConfiguration dataStoreConfiguration, Locale locale) {
		super(dataStoreConfiguration, locale);
	}

	@Override
	public String tableName(CdsEntity entity) {
		SqlMapping mapping = new SqlMapping(entity);
		if (isLocalized(entity) && locale != null) {
			return mapping.localizedViewName();
		}

		return mapping.tableName();
	}
}
