/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.postgresql;

import java.util.function.UnaryOperator;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnPredicate;

public final class PostgreSqlDbContext extends GenericDbContext {
	
	@Override
	public StatementResolver getStatementResolver() {
		return new PostgreSqlStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new PostgreSqlExceptionAnalyzer();
	}

	public PostgreSqlDbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
			@Override
			public int timestampPrecision() {
				return 6;
			}
		};
	}

	@Override
	public UnaryOperator<CqnPredicate> getPredicateMapper() {
		return new PostgreSqlPredicateMapper();
	}
}
