/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.util.function.UnaryOperator;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.cqn.CqnPredicate;

public final class SqliteDbContext extends GenericDbContext {

	public SqliteDbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return new SqliteFunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new SqliteStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new SqliteExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
			@Override
			public boolean supportsLock() {
				return false;
			}
		};
	}

	@Override
	public UnaryOperator<CqnPredicate> getPredicateMapper() {
		return UnaryOperator.identity();
	}

	@Override
	public ValueBinder getBinder() {
		return new SqliteBinder();
	}

}
