/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.reflect.CdsElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;

public class Ref2QualifiedColumn
implements Function<CqnElementRef, String> {
    private final QatSelectableNode root;
    private final QatSelectableNode outer;
    private final String rootName;

    public Ref2QualifiedColumn(Deque<QatSelectableNode> outer) {
        Iterator<QatSelectableNode> reverse = outer.descendingIterator();
        this.root = Ref2QualifiedColumn.qatRoot(reverse.next());
        this.rootName = this.root.rowType().getQualifiedName();
        this.outer = reverse.hasNext() ? reverse.next() : null;
    }

    @Override
    public String apply(CqnElementRef ref) {
        if (ref.firstSegment().equals("$outer")) {
            ElementRef subRef = ElementRefImpl.subRef((CqnElementRef)ref, (int)1);
            return this.qualifiedColumnName((CqnElementRef)subRef, this.outer);
        }
        return this.qualifiedColumnName(ref, this.root);
    }

    private String qualifiedColumnName(CqnElementRef ref, QatNode node) {
        String columnName;
        boolean firstSegment = true;
        for (CqnReference.Segment s : ref.segments()) {
            if (firstSegment && s.id().equals(this.rootName)) continue;
            node = node.child(s.id(), s.filter());
            Ref2QualifiedColumn.assertNotNull(ref, node);
            firstSegment = false;
        }
        if (node instanceof QatElementNode) {
            columnName = this.columnName(node);
        } else {
            throw new CqnValidationException(node.name() + " does not refer to an element");
        }
        while ((node = node.parent()) != null && !(node instanceof QatSelectableNode)) {
        }
        Ref2QualifiedColumn.assertNotNull(ref, node);
        String tableAlias = ((QatSelectableNode)node).alias();
        return Ref2QualifiedColumn.column(tableAlias, columnName);
    }

    private static String column(String alias, String col) {
        return alias + "." + col;
    }

    private static QatSelectableNode qatRoot(QatNode root) {
        Optional<QatNode> next;
        while ((next = Ref2QualifiedColumn.childInSource(root)).isPresent()) {
            root = next.get();
        }
        return (QatSelectableNode)root;
    }

    private static Optional<QatNode> childInSource(QatNode root) {
        return root.children().stream().filter(QatNode::inSource).findFirst();
    }

    private String columnName(QatNode node) {
        QatElementNode elementNode = (QatElementNode)node;
        if (node.parent() instanceof QatStructuredElementNode) {
            CdsElement element = elementNode.element();
            String columnName = SqlMapping.columnName(element);
            if (element.getName().equals(columnName)) {
                return this.structuredColumnName(node);
            }
            return columnName;
        }
        CdsElement cdsElement = elementNode.element();
        return SqlMapping.columnName(cdsElement);
    }

    private String structuredColumnName(QatNode node) {
        ArrayList<String> elementName = new ArrayList<String>();
        elementName.add(((QatElementNode)node).element().getName());
        QatNode parent = node.parent();
        while (parent instanceof QatStructuredElementNode) {
            QatStructuredElementNode structNode = (QatStructuredElementNode)parent;
            elementName.add(structNode.element().getName());
            parent = structNode.parent();
        }
        Collections.reverse(elementName);
        return String.join((CharSequence)"_", elementName);
    }

    private static void assertNotNull(CqnElementRef ref, QatNode node) {
        if (node == null) {
            throw new CqnValidationException("Unresolvable path expression: " + ref.toJson());
        }
    }
}

