/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.google.common.collect.Streams;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.qat.FromClauseBuilder;
import com.sap.cds.impl.qat.QatBuilder;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.Ref2QualifiedColumn;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.impl.SelectBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class SelectStatementBuilder
implements SQLStatementBuilder {
    private final Context context;
    private final CqnSelect select;
    private final Deque<QatSelectableNode> outer;
    private final StatementResolver statementResolver;
    private final SessionContext sessionContext;
    private final List<PreparedCqnStmt.Parameter> params;
    private TokenToSQLTransformer toSQL;

    public SelectStatementBuilder(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, Deque<QatSelectableNode> outer) {
        this.context = context;
        this.params = params;
        this.select = select;
        this.outer = SelectStatementBuilder.append(outer, new QatBuilder(context, select, outer.size()).create());
        this.statementResolver = context.getDbContext().getStatementResolver();
        this.sessionContext = context.getSessionContext();
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        this.toSQL = new TokenToSQLTransformer(this.context, this.params, new Ref2QualifiedColumn(this.outer), this.outer);
        ArrayList<String> snippets = new ArrayList<String>();
        this.with().forEach(snippets::add);
        snippets.add("SELECT");
        this.distinct().forEach(snippets::add);
        this.columns().forEach(snippets::add);
        this.from().forEach(snippets::add);
        this.where().forEach(snippets::add);
        this.groupBy().forEach(snippets::add);
        this.having().forEach(snippets::add);
        this.orderBy().forEach(snippets::add);
        this.limit().forEach(snippets::add);
        this.lock().forEach(snippets::add);
        String sql = snippets.stream().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }

    private Stream<String> distinct() {
        if (this.select.isDistinct()) {
            return Stream.of("DISTINCT");
        }
        return Stream.empty();
    }

    private Stream<String> columns() {
        List items = this.select.items();
        if (items.isEmpty()) {
            throw new IllegalStateException("select * not expected");
        }
        Stream.Builder sql = Stream.builder();
        items.stream().flatMap(CqnSelectListItem::ofValue).forEach(slv -> {
            sql.add(",");
            sql.add(this.toSQL.apply((CqnToken)slv.value()));
            slv.alias().ifPresent(a -> {
                sql.add("as");
                sql.add(SQLHelper.delimited(a));
            });
        });
        return sql.build().skip(1L);
    }

    private Stream<String> with() {
        FromClauseBuilder fromClauseBuilder = new FromClauseBuilder(this.context, this.params, ((SelectBuilder)this.select).hints());
        return fromClauseBuilder.with(this.outer);
    }

    private Stream<String> from() {
        FromClauseBuilder fromClauseBuilder = new FromClauseBuilder(this.context, this.params, ((SelectBuilder)this.select).hints());
        return Streams.concat((Stream[])new Stream[]{Stream.of("FROM"), fromClauseBuilder.sql(this.outer)});
    }

    private Stream<String> where() {
        Optional where = Conjunction.and((Optional)this.select.where(), (Optional)this.select.search());
        CqnSource source = this.select.from();
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            where = Conjunction.and((Optional)where, (Optional)ref.targetSegment().filter());
        }
        Stream.Builder sql = Stream.builder();
        where.map(this.toSQL::toSQL).ifPresent(s -> {
            sql.add("WHERE");
            sql.add(s);
            Optional collateClause = this.statementResolver.collateClause(this.sessionContext.getLocale());
            collateClause.ifPresent(cc -> sql.add(cc));
        });
        return sql.build();
    }

    private Stream<String> groupBy() {
        List groupByTokens = this.select.groupBy();
        if (groupByTokens.isEmpty()) {
            return Stream.empty();
        }
        Stream[] streamArray = new Stream[2];
        streamArray[0] = Stream.of("GROUP BY");
        streamArray[1] = SQLStatementBuilder.commaSeparated(groupByTokens.stream(), this.toSQL::apply);
        return Streams.concat((Stream[])streamArray);
    }

    private Stream<String> having() {
        Optional having = this.select.having();
        Stream.Builder sql = Stream.builder();
        having.map(this.toSQL::toSQL).ifPresent(s -> {
            sql.add("HAVING");
            sql.add(s);
            Optional collateClause = this.statementResolver.collateClause(this.sessionContext.getLocale());
            collateClause.ifPresent(cc -> sql.add(cc));
        });
        return sql.build();
    }

    private Stream<String> orderBy() {
        List orderBy = this.select.orderBy();
        if (orderBy.isEmpty()) {
            return Stream.empty();
        }
        return Streams.concat((Stream[])new Stream[]{Stream.of("ORDER BY"), SQLStatementBuilder.commaSeparated(orderBy.stream(), this::sort)});
    }

    private String sort(CqnSortSpecification o) {
        StringBuilder sort = new StringBuilder(this.toSQL.apply((CqnToken)o.value()));
        this.statementResolver.collateClause(this.sessionContext.getLocale()).ifPresent(cc -> sort.append(" " + cc));
        switch (o.order()) {
            case DESC: {
                sort.append(" DESC NULLS LAST");
                break;
            }
            case DESC_NULLS_FIRST: {
                sort.append(" DESC NULLS FIRST");
                break;
            }
            case ASC_NULLS_LAST: {
                sort.append(" NULLS LAST");
                break;
            }
            default: {
                sort.append(" NULLS FIRST");
            }
        }
        return sort.toString();
    }

    private Stream<String> limit() {
        Stream.Builder sql = Stream.builder();
        this.select.limit().ifPresent(l -> {
            sql.add("LIMIT");
            l.limit().tokens().map(this.toSQL).forEach(sql::add);
            l.offset().ifPresent(o -> {
                sql.add("OFFSET");
                o.tokens().map(this.toSQL).forEach(sql::add);
            });
        });
        return sql.build();
    }

    private Stream<String> lock() {
        Stream.Builder stream = Stream.builder();
        Optional lock = this.select.getLock();
        lock.ifPresent(l -> {
            this.statementResolver.lockClause(l.mode()).ifPresent(stream::add);
            l.timeout().ifPresent(to -> {
                if (to > 0) {
                    this.statementResolver.timeoutClause(to.intValue()).ifPresent(stream::add);
                } else {
                    stream.add("NOWAIT");
                }
            });
        });
        return stream.build();
    }

    private static Deque<QatSelectableNode> append(Deque<QatSelectableNode> prefix, QatSelectableNode newRoot) {
        ArrayDeque<QatSelectableNode> roots = new ArrayDeque<QatSelectableNode>(prefix);
        roots.add(newRoot);
        return roots;
    }
}

