/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpdateStatementBuilder
implements SQLStatementBuilder {
    private final CqnUpdate update;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final TokenToSQLTransformer toSQL;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();
    private final CdsEntity entity;

    public UpdateStatementBuilder(Context context, CqnUpdate update) {
        this.update = update;
        this.entity = context.getCdsModel().getEntity(update.ref().firstSegment());
        this.sqlMapping = new SqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSQL = new TokenToSQLTransformer(context, this.sqlMapping::columnName, this.entity, this.tableName, this.params);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        Stream.Builder<String> builder = Stream.builder();
        builder.add("UPDATE");
        builder.add(this.tableName);
        builder.add("SET");
        builder.add(UpdateStatementBuilder.commaSeparated(this.update.elements().map(e -> {
            ElementRef ref = ElementRefImpl.parse((String)e);
            CdsElement element = CdsModelUtils.element((CdsStructuredType)this.entity, (CqnElementRef)ref);
            this.params.add(SQLHelper.param(e, element));
            return this.sqlMapping.columnName((CqnElementRef)ref) + " = ?";
        })));
        this.update.where().map(this.toSQL::toSQL).ifPresent(s -> {
            builder.add("WHERE");
            builder.add((String)s);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }

    private static String commaSeparated(Stream<String> stream) {
        return stream.collect(Collectors.joining(", ", "", ""));
    }
}

