/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.ConnectedDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.DeleteCascader;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.DeepInsertSplitter;
import com.sap.cds.ql.impl.DeepUpdateSplitter;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.ql.impl.XsertBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.PathExpressionResolver;
import com.sap.cds.util.ProjectionProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsDataStoreImpl
implements CdsDataStore {
    private final CqnValidator cqnValidator;
    private final ConnectedClient connectedClient;
    private final CqnNormalizer cqnNormalizer;
    private final CqnAnalyzer cqnAnalyzer;
    private final DataUtils dataUtils;
    private final Context context;
    private final CdsModel model;
    private final ProjectionProcessor projectionProcessor;
    private static final Logger logger = LoggerFactory.getLogger(CdsDataStoreImpl.class);
    private static final TimingLogger timed = new TimingLogger(logger);

    public CdsDataStoreImpl(Context context, ConnectedDataStoreConnector connector) {
        this.context = context;
        this.model = context.getCdsModel();
        this.cqnValidator = CqnValidator.create(context);
        this.connectedClient = connector.create(context);
        this.dataUtils = DataUtils.create(context::getSessionContext, (int)context.getDbContext().getCapabilities().timestampPrecision());
        this.connectedClient.setSessionContext(context.getSessionContext());
        this.cqnNormalizer = new CqnNormalizer(context);
        this.cqnAnalyzer = CqnAnalyzer.create((CdsModel)this.model);
        this.projectionProcessor = ProjectionProcessor.create((CdsModel)this.model, (CqnAnalyzer)this.cqnAnalyzer, (DataUtils)this.dataUtils);
    }

    public Result execute(CqnSelect select, Object ... paramValues) {
        return this.execute(select, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnSelect select, Map<String, Object> cqnParameterValues) {
        return (Result)timed.debug(() -> {
            CdsEntity rowType = null;
            if (select.from().isRef() && CqnStatementUtils.isSelectStar((List)select.items()) && select.excluding().isEmpty()) {
                rowType = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.from().asRef());
            }
            CqnSelect normSelect = this.cqnNormalizer.normalize(select);
            this.cqnValidator.validate(normSelect, this.connectedClient.capabilities());
            if (rowType == null) {
                rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)normSelect);
            }
            normSelect = this.cqnNormalizer.resolveForwardMappedAssocs(normSelect);
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)normSelect);
            ResultBuilder result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, normSelect.getLock().isPresent()).rowType((CdsStructuredType)rowType);
            if (normSelect.hasInlineCount()) {
                long rowCount = result.result().rowCount();
                if (normSelect.hasLimit() && CdsDataStoreImpl.requiresInlineCountQuery(normSelect.top(), normSelect.skip(), rowCount)) {
                    result.inlineCount(this.getInlineCount(normSelect, cqnParameterValues));
                } else {
                    result.inlineCount(rowCount);
                }
            }
            return result.result();
        }, "CQN >>{}<<", () -> new Object[]{CdsDataStoreImpl.safeToJson(select, this.context.getDataStoreConfiguration())});
    }

    public Result execute(CqnSelect select, Iterable<Map<String, Object>> valueSets, int maxBatchSize) {
        int valueSetSize = Iterables.size(valueSets);
        if (valueSetSize == 1) {
            return this.execute(select, valueSets.iterator().next());
        }
        if (!select.orderBy().isEmpty() && valueSetSize > maxBatchSize) {
            throw new UnsupportedOperationException("Order by is not supported when query is executed in multiple batches");
        }
        ArrayList rows = new ArrayList(valueSetSize);
        UnmodifiableIterator partitions = Iterators.partition(valueSets.iterator(), (int)maxBatchSize);
        while (partitions.hasNext()) {
            CqnSelect batchSelect = CqnStatementUtils.batchSelect((CqnSelect)select, (List)((List)partitions.next()));
            List result = this.execute(batchSelect, new Object[0]).list();
            rows.addAll(result);
        }
        return ResultBuilder.selectedRows(rows).result();
    }

    private long getInlineCount(CqnSelect select, Map<String, Object> cqnParameterValues) {
        CqnSelect inlineCountQuery = CqnStatementUtils.inlineCountQuery((CqnSelect)select);
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)inlineCountQuery);
        Result result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, false).result();
        return ((CqnStatementUtils.Count)result.single(CqnStatementUtils.Count.class)).getCount();
    }

    @VisibleForTesting
    static String safeToJson(CqnSelect select, DataStoreConfiguration config) {
        boolean doLogValues = config.getProperty("cds.ql.logging.log-values", false);
        try {
            if (!doLogValues) {
                return CqnStatementUtils.anonymizeStatement((CqnSelect)select).toJson();
            }
            return select.toJson();
        }
        catch (RuntimeException ex) {
            logger.error("cannot serialize CQN statement");
            return "Unserializable CQN";
        }
    }

    @VisibleForTesting
    static boolean requiresInlineCountQuery(long top, long skip, long rowCount) {
        return skip > 0L || top <= rowCount;
    }

    public Result execute(CqnDelete delete, Object ... paramValues) {
        return this.execute(delete, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnDelete delete, Map<String, Object> namedValues) {
        return this.execute(delete, Collections.singletonList(namedValues));
    }

    public Result execute(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        delete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)delete);
        delete = this.cqnNormalizer.normalize(delete);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)delete.ref());
        try {
            DeleteCascader.create(target).from(delete.ref()).where(delete.where()).cascade(d -> this.bulkDelete((CqnDelete)d, (Iterable<? extends Map<String, Object>>)valueSets, true));
            return this.bulkDelete(delete, valueSets, false);
        }
        catch (UnsupportedOperationException e) {
            target = this.model.getEntity(delete.ref().firstSegment());
            Set<EntityCascader.EntityKeys> entities = this.cascade(target, delete.where(), valueSets);
            Result result = this.bulkDelete(delete, valueSets, false);
            this.delete(entities.stream().map(k -> EntityCascader.EntityOperation.delete(k, this.context.getSessionContext())), true);
            return result;
        }
    }

    private Set<EntityCascader.EntityKeys> cascade(CdsEntity target, Optional<CqnPredicate> filter, Iterable<? extends Map<String, Object>> valueSets) {
        EntityCascader cascader = EntityCascader.from(this, target).where(filter);
        Set<EntityCascader.EntityKeys> keySets = valueSets.iterator().hasNext() ? Streams.stream(valueSets).flatMap(v -> cascader.with((Map<String, Object>)v).cascade(CdsModelUtils.CascadeType.DELETE).stream()).collect(Collectors.toSet()) : cascader.cascade(CdsModelUtils.CascadeType.DELETE);
        return keySets;
    }

    private void upsert(Stream<EntityCascader.EntityOperation> operations) {
        List<EntityCascader.EntityOperation> notInDatastore = this.update(operations);
        this.insert(notInDatastore.stream());
    }

    private void insert(Stream<EntityCascader.EntityOperation> ops) {
        ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity)).forEach((entity, data) -> {
            Iterator rows = this.execute((CqnInsert)Insert.into((CdsEntity)entity).entries((Iterable)data)).iterator();
            for (EntityCascader.EntityOperation op : data) {
                op.inserted((Map)rows.next());
            }
        });
    }

    private List<EntityCascader.EntityOperation> update(Stream<EntityCascader.EntityOperation> ops) {
        ArrayList<EntityCascader.EntityOperation> notFound = new ArrayList<EntityCascader.EntityOperation>();
        ops.collect(Collectors.groupingBy(o -> Objects.hash(o.targetEntity().getQualifiedName(), o.updateValues().keySet()))).forEach((g, updates) -> {
            CdsEntity entity = ((EntityCascader.EntityOperation)((Object)((Object)updates.get(0)))).targetEntity();
            List entries = updates.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpdate)Update.entity((CdsEntity)entity).entries(entries));
            if (result.rowCount() > 0L) {
                Iterator resultIter = result.iterator();
                Iterator updateIter = updates.iterator();
                for (int i = 0; i < result.batchCount(); ++i) {
                    EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)updateIter.next()));
                    long rowCount = result.rowCount(i);
                    u.updated((Map)resultIter.next(), rowCount);
                    if (rowCount != 0L) continue;
                    notFound.add(u);
                }
            } else {
                notFound.addAll((Collection<EntityCascader.EntityOperation>)updates);
            }
        });
        return notFound;
    }

    private void delete(Stream<EntityCascader.EntityOperation> ops, boolean rollbackOnFail) {
        Map<CdsEntity, List<EntityCascader.EntityOperation>> keyMap = ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity));
        keyMap.forEach((entity, op) -> {
            if (!op.isEmpty()) {
                Set keyNames = ((EntityCascader.EntityOperation)((Object)((Object)op.iterator().next()))).targetKeys().keySet();
                DeleteBuilder delete = DeleteBuilder.from((String)entity.getQualifiedName()).matching(CqnParam.params((Collection)keyNames));
                this.bulkDelete((CqnDelete)delete, (Iterable<? extends Map<String, Object>>)op, rollbackOnFail);
                op.forEach(EntityCascader.EntityOperation::deleted);
            }
        });
    }

    private Result bulkDelete(CqnDelete delete, Iterable<? extends Map<String, Object>> valueSets, boolean rollbackOnFail) {
        this.cqnValidator.validate(delete);
        delete = PathExpressionResolver.resolvePath((CdsModel)this.model, (CqnDelete)delete);
        delete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)delete);
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)delete);
        ArrayList<Map<String, Object>> parameterValues = new ArrayList<Map<String, Object>>();
        valueSets.forEach(parameterValues::add);
        try {
            int[] deleteCount = this.connectedClient.executeUpdate(pcqn, parameterValues);
            return ResultBuilder.deletedRows((int[])deleteCount).result();
        }
        catch (Exception e) {
            if (rollbackOnFail) {
                this.connectedClient.setRollbackOnly();
            }
            throw e;
        }
    }

    public Result execute(CqnInsert insert) {
        insert = this.isDraftEnabled(insert);
        insert = this.cqnNormalizer.normalize(insert);
        return this.deepInsert((CqnXsert)insert, false);
    }

    private CqnInsert isDraftEnabled(CqnInsert insert) {
        CdsEntity entity = this.model.getEntity(insert.ref().firstSegment());
        if (entity.findAnnotation("odata.draft.enabled").isPresent()) {
            insert = (CqnInsert)this.projectionProcessor.resolve((CqnStatement)insert);
        }
        return insert;
    }

    public Result execute(CqnUpsert upsert) {
        if (upsert.entries().isEmpty()) {
            return ResultBuilder.insertedRows(Collections.emptyList()).result();
        }
        upsert = this.cqnNormalizer.normalize(upsert);
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)upsert.ref());
        if (((XsertBuilder.UpsertBuilder)upsert).byDeleteAndInsert()) {
            this.deleteByKeys(entity, upsert.entries());
            return this.deepInsert((CqnXsert)upsert, true);
        }
        return this.upsert(upsert, entity);
    }

    private Result upsert(CqnUpsert upsert, CdsEntity entity) {
        List entries = upsert.entries();
        this.dataUtils.prepareForInsert((CdsStructuredType)entity, entries);
        if (DataUtils.isDeep((CdsStructuredType)entity, (Collection)upsert.entries())) {
            throw new UnsupportedOperationException("Deep DB Upserts are not supported");
        }
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)upsert);
        this.connectedClient.executeUpdate(pcqn, upsert.entries());
        return ResultBuilder.insertedRows((List)entries).result();
    }

    private Result deleteByKeys(CdsEntity entity, Iterable<Map<String, Object>> keyValues) {
        Delete delete = Delete.from((CdsEntity)entity).matching(CdsModelUtils.keyNames((CdsStructuredType)entity).stream().collect(Collectors.toMap(k -> k, k -> CQL.param((String)k))));
        DataUtils.normalizedUuidKeys((CdsStructuredType)entity, keyValues);
        return this.execute((CqnDelete)delete, keyValues);
    }

    private Result deepInsert(CqnXsert xsert, boolean rollbackOnFail) {
        CdsEntity entity = this.model.getEntity(xsert.ref().firstSegment());
        List entries = xsert.entries();
        this.dataUtils.prepareForInsert((CdsStructuredType)entity, entries);
        List<Insert> inserts = new DeepInsertSplitter(entity, this.context.getSessionContext()).split(entries);
        boolean isRollbackOnly = rollbackOnFail || inserts.size() > 1;
        inserts.forEach(insert -> {
            this.cqnValidator.validate((CqnInsert)insert);
            insert = (Insert)this.projectionProcessor.resolve((CqnStatement)insert);
            CdsEntity target = this.model.getEntity(insert.ref().firstSegment());
            DataUtils.resolvePaths((CdsEntity)target, (List)insert.entries());
            if (DataUtils.isDeep((CdsStructuredType)target, (Collection)insert.entries())) {
                this.deepInsert((CqnXsert)insert, true);
                return;
            }
            this.dataUtils.processOnInsert((CdsStructuredType)target, (Iterable)insert.entries());
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)insert);
            try {
                this.connectedClient.executeUpdate(pcqn, insert.entries());
            }
            catch (Exception e) {
                if (isRollbackOnly) {
                    this.connectedClient.setRollbackOnly();
                }
                throw e;
            }
        });
        return ResultBuilder.insertedRows((List)entries).result();
    }

    public Result execute(CqnUpdate update, Object ... paramValues) {
        return this.execute(update, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnUpdate update, Map<String, Object> namedValues) {
        return this.execute(update, namedValues.isEmpty() ? Collections.emptyList() : Collections.singletonList(namedValues));
    }

    public Result execute(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        this.cqnValidator.validate(update);
        CdsEntity entity = this.cqnAnalyzer.analyze(update.ref()).targetEntity();
        this.dataUtils.prepareForUpdate((CdsStructuredType)entity, update.entries());
        if (!DataUtils.hasNonKeyValues((CdsStructuredType)entity, (Map)update.data())) {
            Result count = this.selectCountAll(update, entity, update);
            update.entries().forEach(Map::clear);
            return count;
        }
        CqnUpdate normUpdate = this.cqnNormalizer.normalize(update);
        if (DataUtils.isDeep((CdsStructuredType)entity, (Collection)normUpdate.entries()) || !DataUtils.uniformData((CdsStructuredType)entity, (Collection)normUpdate.entries())) {
            Map targetKeys = this.cqnAnalyzer.analyze(update).targetKeyValues();
            return this.deepUpdate(entity, normUpdate, targetKeys);
        }
        CqnUpdate resolvedUpdate = (CqnUpdate)this.projectionProcessor.resolve((CqnStatement)normUpdate);
        if (resolvedUpdate != normUpdate) {
            entity = this.cqnAnalyzer.analyze(resolvedUpdate.ref()).targetEntity();
            this.dataUtils.prepareForUpdate((CdsStructuredType)entity, resolvedUpdate.entries());
            if (DataUtils.isDeep((CdsStructuredType)entity, (Collection)resolvedUpdate.entries())) {
                Map targetKeys = this.cqnAnalyzer.analyze(update).targetKeyValues();
                return this.deepUpdate(entity, resolvedUpdate, targetKeys);
            }
        }
        int[] updateCount = this.flatUpdate(resolvedUpdate, entity, valueSets);
        List<Map<String, Object>> entries = update.entries();
        if (entries.size() == 1) {
            entries = CdsDataStoreImpl.filledList(updateCount.length, (Map)entries.get(0));
        }
        return CdsDataStoreImpl.batchUpdateResult(entries, updateCount);
    }

    private static List<Map<String, Object>> filledList(int length, Map<String, Object> entry) {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(length);
        for (int i = 0; i < length; ++i) {
            entries.add(entry);
        }
        return entries;
    }

    private static Result batchUpdateResult(List<Map<String, Object>> entries, int[] updateCount) {
        return CdsDataStoreImpl.batchUpdateResult(entries, Arrays.stream(updateCount).asLongStream().toArray());
    }

    private static Result batchUpdateResult(List<Map<String, Object>> entries, long[] updateCount) {
        int size = entries.size();
        int length = updateCount.length;
        ResultBuilder builder = ResultBuilder.batchUpdate();
        for (int i = 0; i < length; ++i) {
            builder.addUpdatedRows(updateCount[i], entries.get(Math.min(size, i)));
        }
        return builder.result();
    }

    private int[] flatUpdate(CqnUpdate update, CdsEntity entity, Iterable<Map<String, Object>> valueSets) {
        List<Map<String, Object>> parameterValues = CdsDataStoreImpl.mergeParams(update.entries(), valueSets);
        if (!DocStoreUtils.targetsDocStore((CdsStructuredType)entity)) {
            CqnStatementUtils.moveKeyValuesToWhere((CdsStructuredType)entity, (CqnUpdate)update, (boolean)true);
        }
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)update);
        return this.connectedClient.executeUpdate(pcqn, parameterValues);
    }

    private Result deepUpdate(CdsEntity entity, CqnUpdate update, Map<String, Object> targetKeys) {
        DeepUpdateSplitter updateSplitter = new DeepUpdateSplitter(this);
        EntityCascader.EntityOperations operations = updateSplitter.computeOperations(entity, update, targetKeys);
        try {
            this.delete(operations.filter(EntityCascader.EntityOperation.Operation.DELETE), false);
            this.insert(operations.filter(EntityCascader.EntityOperation.Operation.INSERT));
            this.upsert(operations.filter(EntityCascader.EntityOperation.Operation.UPSERT));
            this.update(operations.filter(EntityCascader.EntityOperation.Operation.UPDATE));
        }
        catch (Exception e) {
            this.connectedClient.setRollbackOnly();
            throw e;
        }
        if (operations.entries().size() == 1 && operations.updateCount().length > 1) {
            return this.searchedUpdateResult(operations);
        }
        return CdsDataStoreImpl.batchUpdateResult(operations.entries(), operations.updateCount());
    }

    private Result searchedUpdateResult(EntityCascader.EntityOperations operations) {
        Map<String, Object> data = operations.entries().get(0);
        return ResultBuilder.updatedRows((long)Arrays.stream(operations.updateCount()).sum(), data).result();
    }

    private Result selectCountAll(CqnUpdate update, CdsEntity entity, CqnUpdate resolvedUpdate) {
        Set keys = CdsModelUtils.keyNames((CdsStructuredType)entity);
        Select countQuery = CqnStatementUtils.countAll((CqnStatement)update);
        long[] rowCount = new long[resolvedUpdate.entries().size()];
        int i = 0;
        for (Map entry : update.entries()) {
            CqnPredicate where = (CqnPredicate)update.where().orElse(CqnBoolLiteral.TRUE);
            where = Conjunction.and((CqnPredicate)where, (CqnPredicate)((CqnPredicate)update.elements().filter(keys::contains).map(key -> CQL.get((String)key).eq((Value)CQL.param((String)key))).collect(Conjunction.and())));
            countQuery.where(where);
            rowCount[i] = ((CqnStatementUtils.Count)this.execute((CqnSelect)countQuery, (Map<String, Object>)entry).single().as(CqnStatementUtils.Count.class)).getCount();
            ++i;
        }
        return CdsDataStoreImpl.batchUpdateResult(CdsDataStoreImpl.filledList(rowCount.length, new HashMap<String, Object>()), rowCount);
    }

    private static List<Map<String, Object>> mergeParams(List<Map<String, Object>> updateData, Iterable<Map<String, Object>> valueSets) {
        ArrayList<Map<String, Object>> paramVals = new ArrayList<Map<String, Object>>();
        if (!valueSets.iterator().hasNext()) {
            updateData.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
            return paramVals;
        }
        valueSets.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
        if (updateData.size() == 1) {
            Map<String, Object> data = updateData.get(0);
            paramVals.forEach(p -> p.putAll(data));
            return paramVals;
        }
        if (updateData.size() == paramVals.size()) {
            Iterator<Map<String, Object>> keyIter = updateData.iterator();
            paramVals.forEach(p -> p.putAll((Map)keyIter.next()));
            return paramVals;
        }
        throw new CdsException("Batch update failed: Parameter value list size (" + paramVals.size() + ") does not match batch size (" + updateData.size() + ")");
    }

    private static Map<String, Object> toIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    public SessionContext getSessionContext() {
        return this.context.getSessionContext();
    }

    public void setSessionContext(SessionContext session) {
        this.context.setSessionContext(session);
        this.connectedClient.setSessionContext(session);
    }
}

