/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsException;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.AssociationLoader;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.ContextImpl;
import com.sap.cds.impl.ExceptionHandler;
import com.sap.cds.impl.JdbcDataSourceAdapter;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.SelectList;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.transaction.TransactionManager;
import com.sap.cds.transaction.TransactionRequiredException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import com.sap.cds.util.PathExpressionResolver;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient
implements ConnectedClient {
    private static final Logger logger = LoggerFactory.getLogger(JDBCClient.class);
    private static final TimingLogger timed = new TimingLogger(logger);
    private final Supplier<SQLDataSourceAdapter> adapter;
    private final TransactionManager transactionManager;
    private final Supplier<Connection> ds;
    private final ValueBinder binder;
    private final ExceptionAnalyzer exceptionAnalyzer;
    private final CdsDataStoreConnector.Capabilities capabilities;
    private Context context;
    private int maxBatchSize;

    public JDBCClient(Context context, Supplier<Connection> ds, TransactionManager transactionManager) {
        this.context = context;
        this.ds = ds;
        this.transactionManager = transactionManager;
        DbContext dbContext = context.getDbContext();
        this.binder = dbContext.getBinder(context.getSessionContext().getTimeZone());
        this.adapter = () -> new JdbcDataSourceAdapter(this.context);
        this.exceptionAnalyzer = context.getDbContext().getExceptionAnalyzer();
        this.capabilities = context.getDbContext().getCapabilities();
        this.maxBatchSize = JDBCClient.getMaxBatchSize(context);
    }

    @Override
    public PreparedCqnStatement prepare(CqnStatement statement) {
        if (statement.isSelect()) {
            return this.prepare(statement.asSelect());
        }
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process(statement);
        CdsEntity root = CdsModelUtils.entity((CdsModel)this.context.getCdsModel(), (CqnStructuredTypeRef)statement.ref());
        CqnStructuredTypeRef ref = null;
        try {
            ref = statement.ref();
        }
        catch (CdsException cdsException) {
            // empty catch block
        }
        return PreparedCqnStmt.createUpdate(stmt.sql(), stmt.params(), ref, root);
    }

    public PreparedCqnStmt prepare(CqnSelect select) {
        CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.context.getCdsModel(), (CqnSelect)select);
        CqnStructuredTypeRef ref = null;
        if (!CqnStatementUtils.containsPathExpression((Optional)select.where())) {
            ref = CqnStatementUtils.targetRef((CqnSelect)select);
        }
        boolean optimizeToManyExpands = ref != null;
        JDBCClient.extendSelectList(select, targetType, optimizeToManyExpands);
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process((CqnStatement)select);
        return PreparedCqnStmt.create(stmt.sql(), select.items(), select.excluding(), stmt.params(), ref, targetType);
    }

    private static void extendSelectList(CqnSelect select, CdsStructuredType targetType, boolean toManyMapping) {
        if (!select.isDistinct() && select.groupBy().isEmpty() && CqnStatementUtils.containsRef((List)select.items())) {
            Set elements = targetType.concreteNonAssociationElements().filter(CdsElement::isKey).map(CdsElement::getName).collect(Collectors.toSet());
            if (toManyMapping) {
                CqnStatementUtils.toManyExpands((CdsStructuredType)targetType, (List)select.items()).filter(e -> JDBCClient.pathExpand(targetType, e)).forEach(exp -> {
                    CqnStructuredTypeRef ref = exp.ref();
                    CdsElement assoc = CdsModelUtils.element((CdsStructuredType)targetType, (List)ref.segments());
                    try {
                        Map<String, String> mapping = JDBCClient.fkMapping(ref, assoc);
                        ((SelectList)exp).setElementMapping(mapping);
                        elements.addAll(mapping.values());
                        logger.debug("Expand to-many " + assoc.getQualifiedName() + " using path");
                    }
                    catch (Exception e) {
                        logger.debug("Expand to-many " + assoc.getQualifiedName() + " using parent-keys due to complex on condition", (Throwable)e);
                    }
                });
            }
            CqnStatementUtils.selectHidden(elements, (CqnSelect)select);
        }
    }

    private static boolean pathExpand(CdsStructuredType parent, CqnExpand exp) {
        if (((ExpandBuilder)exp).lazy() || exp.hasLimit()) {
            return false;
        }
        String PATH = "path";
        CdsElement element = CdsModelUtils.element((CdsStructuredType)parent, (List)exp.ref().segments());
        String expandMethod = (String)element.getAnnotationValue("@cds.java.expand.using", (Object)"path");
        return "path".equals(expandMethod);
    }

    private static Map<String, String> fkMapping(CqnStructuredTypeRef ref, CdsElement toManyAssoc) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        new OnConditionAnalyzer(toManyAssoc, true).getFkMapping().forEach((k, val) -> {
            List segments = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.toList());
            if (val.isRef() && !val.asRef().firstSegment().startsWith("$")) {
                segments.set(segments.size() - 1, val.asRef().lastSegment());
                mapping.put((String)k, Joiner.on((char)'.').join(segments));
            }
        });
        return mapping;
    }

    private static int append(int[] arr, int[] elements, int pos) {
        System.arraycopy(elements, 0, arr, pos, elements.length);
        return pos + elements.length;
    }

    private static void rejectAutoCommit(Connection conn) throws SQLException {
        if (conn.getAutoCommit()) {
            throw new TransactionRequiredException("Connection must not be in auto-commit mode");
        }
    }

    @Override
    public void setContextVariable(String key, String value) {
        if (this.context.getDbContext().getCapabilities().supportsClientInfo()) {
            try (Connection conn = this.ds.get();){
                conn.setClientInfo(key, value);
            }
            catch (SQLException e) {
                throw new CdsDataStoreException(String.format("Failed to set context variable '%s'", key), (Throwable)e);
            }
        }
    }

    @Override
    public ResultBuilder executeQuery(PreparedCqnStatement preparedStmt, Map<String, Object> parameterValues, CdsDataStore dataStore, boolean isTransactionRequired) {
        if (isTransactionRequired) {
            this.requireTransaction();
        }
        PreparedCqnStmt pcqn = (PreparedCqnStmt)preparedStmt;
        String sql = pcqn.toNative();
        CdsStructuredType targetType = pcqn.targetType();
        ResultBuilder result = (ResultBuilder)timed.debug(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "SQL >>{}<<", new Object[]{sql});
        logger.debug("SQL row count: {}", (Object)result.result().rowCount());
        return result;
    }

    @Override
    public int[] executeUpdate(PreparedCqnStatement preparedStmt, List<Map<String, Object>> parameterValues) {
        PreparedCqnStmt pcqn = (PreparedCqnStmt)preparedStmt;
        this.requireTransaction();
        String sql = pcqn.toNative();
        CdsEntity entity = (CdsEntity)pcqn.targetType();
        int[] rowCount = (int[])timed.debug(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "SQL >>{}<<", new Object[]{sql});
        logger.debug("SQL affected rows: {}", (Object)Arrays.stream(rowCount).sum());
        return rowCount;
    }

    private int[] executeBatch(PreparedStatement pstmt, List<PreparedCqnStmt.Parameter> params, List<Map<String, Object>> entries, CdsEntity entity) throws SQLException {
        int row = 0;
        int rcPosition = 0;
        int[] result = new int[entries.size()];
        try {
            ValueBinder.Setter[] setters = this.createSetters(params);
            for (Map<String, Object> entry : entries) {
                this.bindValues(pstmt, entry, params, setters, (CdsStructuredType)entity);
                pstmt.addBatch();
                if (++row % this.maxBatchSize != 0) continue;
                int[] rc = pstmt.executeBatch();
                rcPosition = JDBCClient.append(result, rc, rcPosition);
            }
            int[] rc = pstmt.executeBatch();
            rcPosition = JDBCClient.append(result, rc, rcPosition);
            return result;
        }
        catch (BatchUpdateException ex) {
            ExceptionHandler.chainNextExceptions(ex);
            throw new ExceptionHandler(entity, this.exceptionAnalyzer).cdsBatchException(entries, rcPosition, ex);
        }
    }

    private ValueBinder.Setter[] createSetters(List<PreparedCqnStmt.Parameter> params) {
        int size = params.size();
        ValueBinder.Setter[] setters = new ValueBinder.Setter[size + 1];
        for (int col = 1; col <= size; ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            ValueBinder.Setter setter = this.binder.setter(param.type());
            setters[col] = (arg_0, arg_1, arg_2) -> ((ValueBinder.Setter)setter).set(arg_0, arg_1, arg_2);
        }
        return setters;
    }

    private void requireTransaction() {
        if (!this.transactionManager.isActive()) {
            throw new TransactionRequiredException();
        }
    }

    private void bindValues(PreparedStatement pstmt, Map<String, Object> values, List<PreparedCqnStmt.Parameter> params, ValueBinder.Setter[] binders, CdsStructuredType entity) throws SQLException {
        for (int col = 1; col <= params.size(); ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            Object value = param.get(values);
            if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                value = Jsonizer.json((Object)value);
            }
            try {
                binders[col].set(pstmt, col, value);
                continue;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new CdsDataException("Invalid value for '" + entity + "." + param.name() + "' of type " + param.type(), (Throwable)e);
            }
        }
    }

    private ResultBuilder result(PreparedCqnStmt pcqn, Map<String, Object> parameterValues, ResultSet result, CdsDataStore dataStore) {
        Set<CqnExpand> expands = pcqn.selectListItems().stream().filter(CqnSelectListItem::isExpand).map(CqnSelectListItem::asExpand).collect(Collectors.toSet());
        Set<CqnExpand> toManyExpands = expands.stream().filter(e -> !((SelectList)e).getElementMapping().isEmpty()).collect(Collectors.toSet());
        try {
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            boolean singleRow = this.handleRows(pcqn, result, dataStore, expands, toManyExpands, rows);
            if (!singleRow && !toManyExpands.isEmpty()) {
                this.handleExpands(pcqn, parameterValues, dataStore, toManyExpands, rows);
            }
            return ResultBuilder.selectedRows(rows);
        }
        catch (SQLException e2) {
            ExceptionHandler.chainNextExceptions(e2);
            throw new CdsDataStoreException("Failed to process result set", (Throwable)e2);
        }
    }

    private void handleExpands(PreparedCqnStmt pcqn, Map<String, Object> parameterValues, CdsDataStore dataStore, Set<CqnExpand> toManyExpands, List<Map<String, Object>> rows) {
        this.expand(pcqn.ref(), toManyExpands, rows, dataStore, parameterValues);
        if (!pcqn.excluding().isEmpty()) {
            rows.forEach(row -> row.keySet().removeAll(pcqn.excluding()));
        }
    }

    private boolean handleRows(PreparedCqnStmt pcqn, ResultSet result, CdsDataStore dataStore, Set<CqnExpand> expands, Set<CqnExpand> toManyExpands, List<Map<String, Object>> rows) throws SQLException {
        CdsStructuredType targetType = pcqn.targetType();
        Set keyElements = CdsModelUtils.keyNames((CdsStructuredType)targetType);
        HashMap<String, Object> keyValues = new HashMap<String, Object>(keyElements.size());
        List<CqnSelectListValue> selectList = pcqn.selectListItems().stream().flatMap(CqnSelectListItem::ofValue).collect(Collectors.toList());
        ColumnHandler[] columnHandlers = this.columnHandlers(targetType, selectList, keyElements);
        AssociationLoader assocLoader = expands.isEmpty() ? null : new AssociationLoader(dataStore, targetType);
        Sets.SetView exp = null;
        int rowCounter = 0;
        boolean singleRow = false;
        boolean hasNextRow = result.next();
        while (hasNextRow) {
            Map<String, Object> data;
            block8: {
                block7: {
                    keyElements.forEach(k -> keyValues.put((String)k, null));
                    data = this.extractData(result, selectList, assocLoader, keyValues, columnHandlers);
                    hasNextRow = result.next();
                    if (++rowCounter == 1 && !hasNextRow) {
                        singleRow = true;
                        exp = expands;
                    }
                    if (exp == null) {
                        exp = Sets.difference(expands, toManyExpands);
                    }
                    for (CqnExpand expand : exp) {
                        assocLoader.expand(expand, data);
                    }
                    if (singleRow) break block7;
                    if (!toManyExpands.isEmpty()) break block8;
                }
                pcqn.excluding().forEach(data::remove);
            }
            StructuredType<?> selfRef = JDBCClient.ref(targetType, keyValues);
            rows.add((Map<String, Object>)RowImpl.row(data, selfRef));
            if (!hasNextRow || assocLoader == null) continue;
            assocLoader = new AssociationLoader(dataStore, targetType);
        }
        return singleRow;
    }

    private ColumnHandler[] columnHandlers(CdsStructuredType targetType, List<CqnSelectListValue> selectList, Set<String> keyElements) {
        int size = selectList.size();
        ColumnHandler[] columnHandlers = new ColumnHandler[size];
        for (int i = 0; i < size; ++i) {
            CqnSelectListValue slv = selectList.get(i);
            String displayName = slv.displayName();
            columnHandlers[i] = this.createHandler(targetType, slv, displayName, keyElements);
        }
        return columnHandlers;
    }

    private ColumnHandler createHandler(CdsStructuredType targetType, CqnSelectListValue slv, String displayName, Set<String> keyElements) {
        String[] keyElement = new String[]{null};
        if (slv.value().isRef()) {
            CqnElementRef ref = slv.asRef();
            CdsType type = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref).getType();
            String firstSeg = ref.firstSegment();
            if (keyElements.contains(firstSeg)) {
                keyElement[0] = firstSeg;
            }
            if (type.isArrayed()) {
                CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                ValueBinder.Getter typeMapper = this.binder.getter(CdsBaseType.LARGE_STRING, false);
                ValueBinder.Getter valueExtractor = (result, col) -> {
                    String json = (String)typeMapper.get(result, col);
                    return StructDataParser.parseArrayOf((CdsType)itemsType, (String)json);
                };
                return new ColumnHandler(displayName, (ValueBinder.Getter<Object>)valueExtractor, keyElement[0]);
            }
            if (displayName.endsWith("$json")) {
                ValueBinder.Getter typeMapper = this.binder.getter(CdsBaseType.LARGE_STRING, true);
                ValueBinder.Getter valueExtractor = (result, col) -> {
                    Reader reader = (Reader)typeMapper.get(result, col);
                    if (reader == null) {
                        return Collections.emptyMap();
                    }
                    return JsonParser.map((Reader)reader);
                };
                String prefix = displayName.substring(0, displayName.lastIndexOf("$json"));
                return new ColumnHandler(prefix, (ValueBinder.Getter<Object>)valueExtractor, keyElement[0]);
            }
        }
        CdsBaseType cdsType = JDBCClient.getCdsType(targetType, slv.value());
        boolean mediaType = CqnStatementUtils.isMediaType((CdsStructuredType)targetType, (CqnSelectListItem)slv);
        ValueBinder.Getter valueExtractor = this.binder.getter(cdsType, mediaType);
        return new ColumnHandler(displayName, (ValueBinder.Getter<Object>)valueExtractor, keyElement[0]);
    }

    private Map<String, Object> extractData(ResultSet result, List<CqnSelectListValue> selectList, AssociationLoader assocLoader, Map<String, Object> keyValues, ColumnHandler[] columnHandlers) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>(selectList.size());
        for (int i = 1; i <= result.getMetaData().getColumnCount(); ++i) {
            ColumnHandler column = columnHandlers[i - 1];
            Object value = column.valueExtractor.get(result, i);
            CqnSelectListValue slv = selectList.get(i - 1);
            if (value instanceof Map) {
                this.mergeObject(row, slv, (Map)value, column.displayName);
            } else {
                if (assocLoader != null) {
                    assocLoader.addValueOfRootEntity(slv, value);
                }
                DataUtils.resolvePathAndAdd(row, (String)column.displayName, (Object)value);
            }
            String key = column.key;
            if (key == null) continue;
            keyValues.put(key, value);
        }
        return row;
    }

    private void mergeObject(Map<String, Object> data, CqnSelectListValue slv, Map<String, Object> mapValue, String displayName) {
        CqnElementRef jsonRef = slv.asRef();
        mapValue.forEach((k, v) -> {
            ElementRef innerRef = ElementRefImpl.elementRef((CqnReference)jsonRef);
            innerRef.targetSegment().id(k);
            ElementRef innerSlv = innerRef.as(displayName + k);
            DataUtils.resolvePathAndAdd((Map)data, (String)innerSlv.displayName(), (Object)v);
        });
    }

    private void expand(CqnStructuredTypeRef ref, Collection<CqnExpand> expands, List<Map<String, Object>> rows, CdsDataStore dataStore, Map<String, Object> parameterValues) {
        if (ref != null && !expands.isEmpty()) {
            String fkPrefix = "@fk:";
            expands.forEach(exp -> {
                ArrayList segments = new ArrayList(ref.segments());
                segments.addAll(exp.ref().segments());
                ArrayList expItems = new ArrayList(exp.items());
                HashMap mapping = new HashMap();
                ((SelectList)exp).getElementMapping().forEach((fk, v) -> {
                    String alias = "@fk:" + fk;
                    expItems.add(CQL.get((String)fk).as(alias));
                    mapping.put(alias, "@" + v.replace('.', '_'));
                });
                Select sel = Select.from((StructuredType)CQL.to(segments)).columns(expItems).orderBy(exp.orderBy());
                sel = PathExpressionResolver.resolvePath((CdsModel)this.context.getCdsModel(), (CqnSelect)sel);
                Result expResult = dataStore.execute((CqnSelect)sel, parameterValues);
                DataUtils.merge((List)rows, (List)expResult.list(), (String)exp.displayName(), mapping, (String)"@fk:");
            });
        }
    }

    private Map<String, Object> firstEntry(List<Map<String, Object>> valueList) {
        return valueList.isEmpty() ? Collections.emptyMap() : valueList.get(0);
    }

    private static StructuredType<?> ref(CdsStructuredType type, Map<String, Object> keyValues) {
        if (type instanceof CdsEntity && !keyValues.containsValue(null)) {
            return StructuredTypeImpl.structuredType((String)type.getQualifiedName()).matching(keyValues);
        }
        return null;
    }

    private static CdsBaseType getCdsType(CdsStructuredType rowType, CqnValue value) {
        CdsType t;
        Optional type = value.type();
        if (type.isPresent()) {
            String cdsTypeName = (String)type.get();
            try {
                return CdsBaseType.cdsType((String)cdsTypeName);
            }
            catch (CdsException e) {
                logger.warn("Failed to cast to {}", (Object)cdsTypeName);
                return null;
            }
        }
        if (value.isRef() && (t = CdsModelUtils.element((CdsStructuredType)rowType, (CqnElementRef)value.asRef()).getType()).isSimple()) {
            return ((CdsSimpleType)t.as(CdsSimpleType.class)).getType();
        }
        if (value.isLiteral()) {
            CqnLiteral literal = value.asLiteral();
            if (literal.isNumeric()) {
                return CdsBaseType.DECIMAL;
            }
            if (literal.isBoolean()) {
                return CdsBaseType.BOOLEAN;
            }
            if (literal.isString()) {
                return CdsBaseType.STRING;
            }
        }
        logger.debug("Cannot determine CDS type of {}", (Object)value);
        return null;
    }

    @Override
    public void setSessionContext(SessionContext session) {
        this.context = ContextImpl.context(this.context.getCdsModel(), this.context.getDbContext(), session, this.context.getDataStoreConfiguration());
        this.maxBatchSize = JDBCClient.getMaxBatchSize(this.context);
        this.setContextVariable("LOCALE", LocaleUtils.getLocaleString((Locale)session.getLocale()));
        this.setContextVariable("VALID-FROM", session.getValidFrom() != null ? session.getValidFrom().toString() : null);
        this.setContextVariable("VALID-TO", session.getValidTo() != null ? session.getValidTo().toString() : null);
        this.setContextVariable("APPLICATIONUSER", session.getUserContext().getId() != null ? session.getUserContext().getId() : null);
    }

    private static int getMaxBatchSize(Context context) {
        return Math.max(1, context.getDataStoreConfiguration().getProperty("cds.sql.max-batch-size", 1000));
    }

    @Override
    public CdsDataStoreConnector.Capabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public void setRollbackOnly() {
        this.transactionManager.setRollbackOnly();
    }

    private class ColumnHandler {
        final String displayName;
        final ValueBinder.Getter<Object> valueExtractor;
        final String key;

        ColumnHandler(String displayName, ValueBinder.Getter<Object> valueExtractor, String key) {
            this.displayName = displayName;
            this.valueExtractor = valueExtractor;
            this.key = key;
        }
    }
}

