/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericBinder;
import com.sap.cds.jdbc.generic.GenericExceptionAnalyzer;
import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.jdbc.generic.GenericPredicateMapper;
import com.sap.cds.jdbc.generic.GenericSearchResolver;
import com.sap.cds.jdbc.generic.GenericStatementResolver;
import com.sap.cds.jdbc.generic.GenericTableNameResolver;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.UnaryOperator;

public abstract class GenericDbContext
implements DbContext {
    protected final DataStoreConfiguration dataStoreConfiguration;

    public GenericDbContext(DataStoreConfiguration dataStoreConfiguration) {
        this.dataStoreConfiguration = dataStoreConfiguration;
    }

    public TableNameResolver createTableNameResolver(Locale locale) {
        return new GenericTableNameResolver(this.dataStoreConfiguration, locale);
    }

    public SearchResolver createSearchResolver(CdsModel model, Locale locale) {
        return new GenericSearchResolver(model, locale);
    }

    public FunctionMapper getFunctionMapper() {
        return new GenericFunctionMapper();
    }

    public StatementResolver getStatementResolver() {
        return new GenericStatementResolver();
    }

    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new GenericExceptionAnalyzer();
    }

    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return CdsDataStoreConnector.Capabilities.ALL;
    }

    public UnaryOperator<CqnPredicate> getPredicateMapper() {
        return new GenericPredicateMapper();
    }

    public ValueBinder getBinder(TimeZone timeZone) {
        return new GenericBinder(this.getCapabilities().timestampPrecision(), timeZone);
    }
}

