/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnStatement;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HanaStatementResolver
implements StatementResolver {
    private final DataStoreConfiguration dataStoreConfiguration;
    private final int majorVersion;

    public HanaStatementResolver(DataStoreConfiguration dataStoreConfiguration, int majorVersion) {
        this.dataStoreConfiguration = dataStoreConfiguration;
        this.majorVersion = majorVersion;
    }

    public Optional<String> timeoutClause(int timeoutSeconds) {
        return Optional.of("WAIT " + timeoutSeconds);
    }

    public Optional<String> collateClause(CqnStatement statement, Locale locale) {
        boolean ignoreLocaleOnHana = this.dataStoreConfiguration.getProperty("cds.sql.hana.ignore-locale", false);
        if (locale != null && !ignoreLocaleOnHana && this.statementNeedsCollateClause(statement)) {
            return Optional.of("with parameters('LOCALE' = " + SQLHelper.literal(locale.getLanguage()) + ")");
        }
        return Optional.empty();
    }

    private boolean statementNeedsCollateClause(CqnStatement statement) {
        return statement.isDelete() && statement.asDelete().where().isPresent() || statement.isUpdate() && statement.asUpdate().where().isPresent() || statement.isSelect();
    }

    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        String columns = SQLHelper.commaSeparated(upsertColumns);
        String values = SQLHelper.commaSeparated(upsertValues);
        return Stream.of("UPSERT", table, columns, "VALUES", values, "WITH PRIMARY KEY").collect(Collectors.joining(" "));
    }

    public Optional<String> lockClause(CqnLock.Mode mode) {
        String clause;
        switch (mode) {
            case SHARED: {
                if (this.majorVersion >= 4) {
                    clause = "FOR SHARE LOCK";
                    break;
                }
            }
            default: {
                clause = "FOR UPDATE";
            }
        }
        return Optional.of(clause);
    }
}

