/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnLock;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PostgreSqlStatementResolver
implements StatementResolver {
    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        List col = upsertColumns.collect(Collectors.toList());
        String columns = SQLHelper.commaSeparated(col.stream());
        String insertValues = SQLHelper.commaSeparated(upsertValues);
        String conflictTarget = SQLHelper.commaSeparated(keyColumns);
        String updateValues = SQLHelper.commaSeparated(col.stream().map(c -> "EXCLUDED." + c));
        return Stream.of("INSERT INTO", table, columns, "VALUES", insertValues, "ON CONFLICT", conflictTarget, "DO UPDATE SET", columns, "=", updateValues).collect(Collectors.joining(" "));
    }

    public Optional<String> lockClause(CqnLock.Mode mode) {
        String clause;
        switch (mode) {
            case SHARED: {
                clause = "FOR SHARE";
                break;
            }
            default: {
                clause = "FOR UPDATE";
            }
        }
        return Optional.of(clause);
    }
}

