/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Lists;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Insert;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeepInsertSplitter {
    private final CdsEntity entity;
    private final Map<String, List<Map<String, Object>>> insertEntries = new LinkedHashMap<String, List<Map<String, Object>>>();
    private final SessionContext sessionContext;

    public DeepInsertSplitter(CdsModel model, String entityName, SessionContext sessionContext) {
        this(model.getEntity(entityName), sessionContext);
    }

    public DeepInsertSplitter(CdsEntity entity, SessionContext sessionContext) {
        this.entity = entity;
        this.sessionContext = sessionContext;
    }

    public List<Insert> split(List<Map<String, Object>> entries) {
        entries.forEach(entry -> this.flattenEntry(this.entity, (Map<String, Object>)entry));
        return this.computeInserts();
    }

    public List<Insert> split(Map<String, Object> entry) {
        this.flattenEntry(this.entity, entry);
        return this.computeInserts();
    }

    private List<Insert> computeInserts() {
        List inserts = this.insertEntries.entrySet().stream().map(e -> {
            String entity = (String)e.getKey();
            return Insert.into((String)entity).entries((Iterable)e.getValue());
        }).collect(Collectors.toList());
        return Lists.reverse(inserts);
    }

    private void flattenEntry(CdsEntity entity, Map<String, Object> entry) {
        HashMap<String, Object> flatEntry = new HashMap<String, Object>();
        String entityName = entity.getName();
        for (Map.Entry<String, Object> e : entry.entrySet()) {
            String elementName = e.getKey();
            Object value = e.getValue();
            Optional assoc = entity.findAssociation(elementName);
            if (assoc.isPresent()) {
                if (value == null) continue;
                CdsElement association = (CdsElement)assoc.get();
                if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                    this.handleReverseAssociation(entity, association, entry, value);
                    continue;
                }
                this.handleForwardAssociation(flatEntry, entityName, value, association);
                continue;
            }
            Optional element = entity.findElement(elementName);
            if (element.isPresent() && ((CdsElement)element.get()).getType().isStructured()) {
                CdsElement structElement = (CdsElement)element.get();
                if (value == null) continue;
                flatEntry.put(structElement.getName(), this.collectStructElement(value, structElement));
                continue;
            }
            if (flatEntry.containsKey(elementName)) {
                e.setValue(flatEntry.get(elementName));
                continue;
            }
            flatEntry.put(elementName, value);
        }
        this.insertEntries.computeIfAbsent(entity.getQualifiedName(), k -> new ArrayList()).add(flatEntry);
    }

    private void handleForwardAssociation(Map<String, Object> flatEntry, String entityName, Object value, CdsElement association) {
        Map<String, Object> targetValues = DeepInsertSplitter.asMap(entityName, association.getName(), value);
        flatEntry.putAll(this.computeFkValues(association, targetValues));
        if (DeepInsertSplitter.cascadeInsert(association)) {
            this.assertInputDataContainsKeys(association, targetValues);
            CdsAssociationType assocType = (CdsAssociationType)association.getType();
            this.flattenEntry(assocType.getTarget(), targetValues);
        } else {
            Set assocKeys = CdsModelUtils.assocKeys((CdsElement)association);
            targetValues.keySet().retainAll(assocKeys);
        }
    }

    private Map<String, Object> collectStructElement(Object value, CdsElement element) {
        HashMap<String, Object> flatEntry = new HashMap<String, Object>();
        Map valueMap = (Map)value;
        CdsStructuredType structElement = (CdsStructuredType)element.getType().as(CdsStructuredType.class);
        structElement.associations().filter(f -> valueMap.keySet().contains(f.getName())).forEach(assoc -> this.handleForwardAssociation((Map<String, Object>)flatEntry, element.getDeclaringType().getName(), valueMap.get(assoc.getName()), (CdsElement)assoc));
        structElement.nonAssociationElements().filter(f -> valueMap.keySet().contains(f.getName())).forEach(e -> {
            if (e.getType().isStructured()) {
                flatEntry.put(e.getName(), this.collectStructElement(valueMap.get(e.getName()), (CdsElement)e));
            } else {
                flatEntry.put(e.getName(), valueMap.get(e.getName()));
            }
        });
        return flatEntry;
    }

    private void handleReverseAssociation(CdsEntity entity, CdsElement association, Map<String, Object> entry, Object targetVal) {
        if (DeepInsertSplitter.cascadeInsert(association)) {
            CdsAssociationType assoc = (CdsAssociationType)association.getType();
            Map fkValues = new OnConditionAnalyzer(association, true, this.sessionContext).getFkValues(entry);
            List<Map<String, Object>> targetValues = DeepInsertSplitter.asList(entity.getName(), association.getName(), targetVal);
            for (Map<String, Object> child : targetValues) {
                child.putAll(fkValues);
                this.flattenEntry(assoc.getTarget(), child);
            }
        } else {
            throw new UnsupportedOperationException("Cannot set reference " + entity.getQualifiedName() + "." + association.getName() + ". Reverse associations are not supported.");
        }
    }

    private static boolean cascadeInsert(CdsElement element) {
        return CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)element);
    }

    private Map<String, Object> computeFkValues(CdsElement assoc, Map<String, Object> targetValues) {
        return new OnConditionAnalyzer(assoc, false, this.sessionContext).getFkValues(targetValues);
    }

    private void assertInputDataContainsKeys(CdsElement association, Map<String, Object> targetValues) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        Set keyNames = CdsModelUtils.keyNames((CdsStructuredType)assoc.getTarget());
        if (!targetValues.keySet().containsAll(keyNames)) {
            if (DataUtils.isFkUpdate((CdsElement)association, targetValues, (SessionContext)this.sessionContext)) {
                return;
            }
            throw new CdsDataException("Data set " + targetValues.keySet() + " for association " + association.getQualifiedName() + " does not contain values for all target entity keys " + keyNames + ".");
        }
    }

    private static Map<String, Object> asMap(String entityName, String associationName, Object value) {
        try {
            return (Map)value;
        }
        catch (ClassCastException ex) {
            throw DeepInsertSplitter.badValue(entityName, associationName, ex);
        }
    }

    private static List<Map<String, Object>> asList(String entityName, String associationName, Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        throw DeepInsertSplitter.badValue(entityName, associationName, null);
    }

    private static RuntimeException badValue(String entityName, String associationName, RuntimeException cause) {
        return new CdsDataException("Unexpected value: Entity '" + entityName + "' contains unexpected value for the association '" + associationName + "'. ", (Throwable)cause);
    }
}

