/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class MatchPredicateNormalizer {
    private static final RefSegment $OUTER = RefSegmentImpl.refSegment((String)"$outer");
    private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
    private final CdsModel model;
    private final CdsStructuredType target;

    public MatchPredicateNormalizer(CdsModel model, CdsStructuredType target) {
        this.model = model;
        this.target = target;
    }

    public <S extends CqnStatement> S normalize(S s) {
        s = CQL.copy(s, (Modifier)new Path2Nested());
        s = CQL.copy(s, (Modifier)new Match2Exists());
        return s;
    }

    public Predicate normalize(CqnPredicate pred) {
        Predicate copy = CQL.copy((CqnPredicate)pred, (Modifier)new Path2Nested());
        copy = CQL.copy((CqnPredicate)copy, (Modifier)new Match2Exists());
        return copy;
    }

    private static CdsStructuredType navigate(CdsStructuredType rowType, String id) {
        CdsType type = rowType.getElement(id).getType();
        if (type.isStructured()) {
            return (CdsStructuredType)type.as(CdsStructuredType.class);
        }
        if (type.isAssociation()) {
            return ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
        }
        String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", rowType.getQualifiedName(), id);
        throw new CqnValidationException(message);
    }

    private class Match2Exists
    implements Modifier {
        private Match2Exists() {
        }

        public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
            return this.resolveInfixFilters(MatchPredicateNormalizer.this.model.getStructuredType(ref.firstSegment()), ref);
        }

        private CqnStructuredTypeRef resolveInfixFilters(CdsStructuredType rowType, StructuredTypeRef ref) {
            Iterator iter = ref.segments().iterator();
            RefSegment seg = (RefSegment)iter.next();
            this.normalizeSegment(seg, rowType);
            while (iter.hasNext()) {
                seg = (RefSegment)iter.next();
                rowType = MatchPredicateNormalizer.navigate(rowType, seg.id());
                this.normalizeSegment(seg, rowType);
            }
            return ref;
        }

        public CqnSelectListItem expand(Expand<?> expand) {
            this.resolveInfixFilters(MatchPredicateNormalizer.this.target.getTargetOf(expand.ref().firstSegment()), expand.ref());
            return expand;
        }

        public Predicate match(StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
            CdsElement association = this.getAssociation((CqnStructuredTypeRef)ref);
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            StructuredTypeRef from = this.absoluteRef(target, (CqnStructuredTypeRef)ref);
            this.rejectToManyPathInFilter(target, pred);
            CqnPredicate where = this.innerToOuter(this.getPrefix((CqnStructuredTypeRef)ref), association);
            if (pred != null) {
                pred = this.normalize((CdsStructuredType)target, (CqnPredicate)pred);
                if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                    pred = CQL.not((CqnPredicate)pred);
                }
                where = Conjunction.and((CqnPredicate)where, (CqnPredicate)pred);
            }
            Select subquery = Select.from((CqnStructuredTypeRef)from).where(where);
            ExistsSubquery exists = new ExistsSubquery((CqnSelect)subquery);
            if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                return exists.not();
            }
            return exists;
        }

        private void rejectToManyPathInFilter(final CdsEntity entity, Predicate pred) {
            if (pred == null) {
                return;
            }
            CqnVisitor visitor = new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    CdsEntity structType = entity;
                    for (CqnReference.Segment segment : ref.segments()) {
                        CdsType elType = structType.getElement(segment.id()).getType();
                        if (elType.isStructured()) {
                            structType = (CdsStructuredType)elType.as(CdsStructuredType.class);
                            continue;
                        }
                        if (!elType.isAssociation()) continue;
                        CdsAssociationType assoc = (CdsAssociationType)elType.as(CdsAssociationType.class);
                        structType = assoc.getTarget();
                        if (!CdsModelUtils.isToMany((CdsType)assoc)) continue;
                        String message = MessageFormat.format("Association ''{0}'' with to-many target cardinality in anyMatch/allMatch is not supported", segment.id());
                        throw new CqnValidationException(message);
                    }
                }
            };
            pred.accept(visitor);
        }

        private CqnPredicate innerToOuter(final List<CqnReference.Segment> outerPrefix, final CdsElement association) {
            CqnPredicate on = MatchPredicateNormalizer.this.associationAnalyzer.getOnCondition(association);
            Modifier m = new Modifier(){

                public Value<?> ref(ElementRef<?> ref) {
                    LinkedList segments = new LinkedList(ref.segments());
                    if (ref.firstSegment().equals(association.getName())) {
                        segments.remove(0);
                    } else {
                        segments.addAll(0, outerPrefix);
                    }
                    return ElementRefImpl.element(segments);
                }
            };
            on = ExpressionVisitor.copy((CqnPredicate)on, (Modifier)m);
            return on;
        }

        private StructuredTypeRef absoluteRef(CdsEntity target, CqnStructuredTypeRef ref) {
            RefSegment seg = RefSegmentImpl.copy((CqnReference.Segment)ref.targetSegment()).id(target.getQualifiedName());
            return StructuredTypeRefImpl.typeRef(Arrays.asList(seg));
        }

        private void normalizeSegment(RefSegment seg, CdsStructuredType rowType) {
            seg.filter().ifPresent(f -> seg.filter((CqnPredicate)this.normalize(rowType, (CqnPredicate)f)));
        }

        private Predicate normalize(CdsStructuredType rowType, CqnPredicate pred) {
            return new MatchPredicateNormalizer(MatchPredicateNormalizer.this.model, rowType).normalize(pred);
        }

        private List<CqnReference.Segment> getPrefix(CqnStructuredTypeRef ref) {
            List all = ref.segments();
            int size = all.size();
            List start = all.subList(0, size - 1);
            ArrayList<CqnReference.Segment> prefix = new ArrayList<CqnReference.Segment>(size);
            prefix.add((CqnReference.Segment)$OUTER);
            prefix.addAll(start);
            return prefix;
        }

        private CdsElement getAssociation(CqnStructuredTypeRef ref) {
            CdsStructuredType rowType = MatchPredicateNormalizer.this.target;
            String root = rowType.getQualifiedName();
            CdsElement element = CdsModelUtils.element((CdsStructuredType)rowType, (List)ref.segments());
            CdsType elementType = element.getType();
            if (!elementType.isAssociation()) {
                String path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
                String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", root, path);
                throw new CqnValidationException(message);
            }
            return element;
        }
    }

    private class Path2Nested
    implements Modifier {
        private Path2Nested() {
        }

        public Predicate match(StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
            return this.convertToNestedIfNecessary(MatchPredicateNormalizer.this.target, ref, pred, quantifier);
        }

        private Predicate convertToNestedIfNecessary(CdsStructuredType rowType, StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
            List segments = ref.segments();
            int n = segments.size();
            for (int i = 1; i < n; ++i) {
                CqnReference.Segment segment = (CqnReference.Segment)segments.get(i - 1);
                CdsElement element = rowType.getElement(segment.id());
                CdsType elementType = element.getType();
                if (elementType.isStructured()) {
                    rowType = (CdsStructuredType)elementType.as(CdsStructuredType.class);
                    continue;
                }
                if (!elementType.isAssociation()) continue;
                rowType = ((CdsAssociationType)elementType.as(CdsAssociationType.class)).getTarget();
                if (CdsModelUtils.isSingleValued((CdsType)elementType)) continue;
                StructuredTypeRef prefix = StructuredTypeRefImpl.typeRef(segments.subList(0, i));
                StructuredTypeRef suffix = StructuredTypeRefImpl.typeRef(segments.subList(i, n));
                Predicate nested = this.convertToNestedIfNecessary(rowType, suffix, pred, quantifier);
                return MatchPredicate.match((CqnStructuredTypeRef)prefix, (CqnMatchPredicate.Quantifier)quantifier, (CqnPredicate)nested);
            }
            return MatchPredicate.match((CqnStructuredTypeRef)ref, (CqnMatchPredicate.Quantifier)quantifier, (CqnPredicate)pred);
        }
    }
}

