/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.parser.token.RefSegmentBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.util.CdsModelUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cascader {
    private static final Logger logger = LoggerFactory.getLogger(Cascader.class);
    private final CdsModelUtils.CascadeType cascadeType;
    private final CdsEntity entity;
    private final Set<String> visited = new HashSet<String>();
    private final LinkedList<StructuredType<?>> paths = new LinkedList();
    private CqnStructuredTypeRef ref;
    private CqnPredicate filter;
    private boolean unsupported = false;

    private Cascader(CdsModelUtils.CascadeType cascadeType, CdsEntity entity) {
        this.cascadeType = cascadeType;
        this.entity = entity;
    }

    public static Cascader create(CdsModelUtils.CascadeType cascadeType, CdsEntity entity) {
        return new Cascader(cascadeType, entity);
    }

    public Cascader from(String path) {
        return this.from((CqnStructuredTypeRef)(path != null ? CQL.to((String)path).asRef() : null));
    }

    public Cascader from(CqnStructuredTypeRef ref) {
        this.ref = ref;
        return this;
    }

    public Cascader where(Optional<CqnPredicate> filter) {
        filter.ifPresent(f -> f.accept(new CqnVisitor((CqnPredicate)f){
            final /* synthetic */ CqnPredicate val$f;
            {
                this.val$f = cqnPredicate;
            }

            public void visit(CqnExistsSubquery query) {
                logger.debug("Cascading delete on {} cannot be optimized due to condition: {}", (Object)Cascader.this.entity.getQualifiedName(), (Object)this.val$f);
                Cascader.this.unsupported = true;
            }
        }));
        this.filter = filter.orElse(null);
        return this;
    }

    public boolean cascade(Consumer<StructuredType<?>> action) {
        boolean acyclic;
        StructuredType path;
        if (this.unsupported) {
            return false;
        }
        StructuredType structuredType = path = this.ref != null ? CQL.to((List)RefSegmentBuilder.copy((List)this.ref.segments())) : null;
        if (path != null && this.filter != null) {
            path.filter((CqnPredicate)this.ref.targetSegment().filter().map(f -> CQL.and((CqnPredicate)f, (CqnPredicate)this.filter)).orElse((Predicate)this.filter));
        }
        if (acyclic = this.cascade(path, this.entity)) {
            this.paths.forEach(action::accept);
        }
        return acyclic;
    }

    private boolean cascade(StructuredType<?> path, CdsEntity entity) {
        return entity.associations().filter(a -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)this.cascadeType, (CdsElement)a)).allMatch(assoc -> this.cascade(path, (CdsElement)assoc));
    }

    private boolean cascade(StructuredType<?> path, CdsElement association) {
        CdsAssociationType assocType = (CdsAssociationType)association.getType();
        CdsEntity target = assocType.getTarget();
        if (!this.visited.add(association.getQualifiedName())) {
            logger.debug("Cascading delete on {} cannot be optimized due to cycle in delete graph: {}", (Object)this.entity.getQualifiedName(), (Object)association.getQualifiedName());
            return false;
        }
        StructuredType p = path != null ? path.to(association.getName()) : CQL.to((String)association.getName());
        this.paths.addFirst(p);
        return this.cascade(p, target);
    }
}

